/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificates.model.RevocationStatus;
import com.oracle.bmc.certificates.model.Validity;
import com.oracle.bmc.certificates.model.VersionStage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CertificateBundleVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="versionName")
    private final String versionName;
    @JsonProperty(value="certificateName")
    private final String certificateName;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="validity")
    private final Validity validity;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="stages")
    private final List<VersionStage> stages;
    @JsonProperty(value="revocationStatus")
    private final RevocationStatus revocationStatus;

    @Deprecated
    @ConstructorProperties(value={"certificateId", "serialNumber", "versionName", "certificateName", "versionNumber", "timeCreated", "validity", "timeOfDeletion", "stages", "revocationStatus"})
    public CertificateBundleVersionSummary(String certificateId, String serialNumber, String versionName, String certificateName, Long versionNumber, Date timeCreated, Validity validity, Date timeOfDeletion, List<VersionStage> stages, RevocationStatus revocationStatus) {
        this.certificateId = certificateId;
        this.serialNumber = serialNumber;
        this.versionName = versionName;
        this.certificateName = certificateName;
        this.versionNumber = versionNumber;
        this.timeCreated = timeCreated;
        this.validity = validity;
        this.timeOfDeletion = timeOfDeletion;
        this.stages = stages;
        this.revocationStatus = revocationStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public List<VersionStage> getStages() {
        return this.stages;
    }

    public RevocationStatus getRevocationStatus() {
        return this.revocationStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateBundleVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", versionName=").append(String.valueOf(this.versionName));
        sb.append(", certificateName=").append(String.valueOf(this.certificateName));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", validity=").append(String.valueOf((Object)this.validity));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", stages=").append(String.valueOf(this.stages));
        sb.append(", revocationStatus=").append(String.valueOf((Object)this.revocationStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateBundleVersionSummary)) {
            return false;
        }
        CertificateBundleVersionSummary other = (CertificateBundleVersionSummary)((Object)o);
        return Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.versionName, other.versionName) && Objects.equals(this.certificateName, other.certificateName) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.validity, (Object)other.validity) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.stages, other.stages) && Objects.equals((Object)this.revocationStatus, (Object)other.revocationStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.versionName == null ? 43 : this.versionName.hashCode());
        result = result * 59 + (this.certificateName == null ? 43 : this.certificateName.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.validity == null ? 43 : this.validity.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.stages == null ? 43 : this.stages.hashCode());
        result = result * 59 + (this.revocationStatus == null ? 43 : this.revocationStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="certificateName")
        private String certificateName;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="validity")
        private Validity validity;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="stages")
        private List<VersionStage> stages;
        @JsonProperty(value="revocationStatus")
        private RevocationStatus revocationStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            this.__explicitlySet__.add("certificateName");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder validity(Validity validity) {
            this.validity = validity;
            this.__explicitlySet__.add("validity");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder stages(List<VersionStage> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder revocationStatus(RevocationStatus revocationStatus) {
            this.revocationStatus = revocationStatus;
            this.__explicitlySet__.add("revocationStatus");
            return this;
        }

        public CertificateBundleVersionSummary build() {
            CertificateBundleVersionSummary model = new CertificateBundleVersionSummary(this.certificateId, this.serialNumber, this.versionName, this.certificateName, this.versionNumber, this.timeCreated, this.validity, this.timeOfDeletion, this.stages, this.revocationStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateBundleVersionSummary model) {
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("versionName")) {
                this.versionName(model.getVersionName());
            }
            if (model.wasPropertyExplicitlySet("certificateName")) {
                this.certificateName(model.getCertificateName());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("validity")) {
                this.validity(model.getValidity());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("stages")) {
                this.stages(model.getStages());
            }
            if (model.wasPropertyExplicitlySet("revocationStatus")) {
                this.revocationStatus(model.getRevocationStatus());
            }
            return this;
        }
    }
}

