/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.budget.model.CreateBudgetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBudgetRequest
extends BmcRequest<CreateBudgetDetails> {
    private CreateBudgetDetails createBudgetDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateBudgetDetails getCreateBudgetDetails() {
        return this.createBudgetDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateBudgetDetails getBody$() {
        return this.createBudgetDetails;
    }

    public Builder toBuilder() {
        return new Builder().createBudgetDetails(this.createBudgetDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createBudgetDetails=").append(String.valueOf((Object)this.createBudgetDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createBudgetDetails, (Object)other.createBudgetDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createBudgetDetails == null ? 43 : this.createBudgetDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBudgetRequest, CreateBudgetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateBudgetDetails createBudgetDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createBudgetDetails(CreateBudgetDetails createBudgetDetails) {
            this.createBudgetDetails = createBudgetDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBudgetRequest o) {
            this.createBudgetDetails(o.getCreateBudgetDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBudgetRequest build() {
            CreateBudgetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBudgetDetails body) {
            this.createBudgetDetails(body);
            return this;
        }

        public CreateBudgetRequest buildWithoutInvocationCallback() {
            CreateBudgetRequest request = new CreateBudgetRequest();
            request.createBudgetDetails = this.createBudgetDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

