/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.CreatePeerDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePeerRequest
extends BmcRequest<CreatePeerDetails> {
    private String blockchainPlatformId;
    private CreatePeerDetails createPeerDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public CreatePeerDetails getCreatePeerDetails() {
        return this.createPeerDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreatePeerDetails getBody$() {
        return this.createPeerDetails;
    }

    public Builder toBuilder() {
        return new Builder().blockchainPlatformId(this.blockchainPlatformId).createPeerDetails(this.createPeerDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",blockchainPlatformId=").append(String.valueOf(this.blockchainPlatformId));
        sb.append(",createPeerDetails=").append(String.valueOf((Object)this.createPeerDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePeerRequest)) {
            return false;
        }
        CreatePeerRequest other = (CreatePeerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.blockchainPlatformId, other.blockchainPlatformId) && Objects.equals((Object)this.createPeerDetails, (Object)other.createPeerDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockchainPlatformId == null ? 43 : this.blockchainPlatformId.hashCode());
        result = result * 59 + (this.createPeerDetails == null ? 43 : this.createPeerDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePeerRequest, CreatePeerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String blockchainPlatformId = null;
        private CreatePeerDetails createPeerDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder createPeerDetails(CreatePeerDetails createPeerDetails) {
            this.createPeerDetails = createPeerDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePeerRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.createPeerDetails(o.getCreatePeerDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePeerRequest build() {
            CreatePeerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePeerDetails body) {
            this.createPeerDetails(body);
            return this;
        }

        public CreatePeerRequest buildWithoutInvocationCallback() {
            CreatePeerRequest request = new CreatePeerRequest();
            request.blockchainPlatformId = this.blockchainPlatformId;
            request.createPeerDetails = this.createPeerDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

