/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReplicaDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="proxyCount")
    private final Integer proxyCount;
    @JsonProperty(value="caCount")
    private final Integer caCount;
    @JsonProperty(value="consoleCount")
    private final Integer consoleCount;

    @Deprecated
    @ConstructorProperties(value={"proxyCount", "caCount", "consoleCount"})
    public ReplicaDetails(Integer proxyCount, Integer caCount, Integer consoleCount) {
        this.proxyCount = proxyCount;
        this.caCount = caCount;
        this.consoleCount = consoleCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getProxyCount() {
        return this.proxyCount;
    }

    public Integer getCaCount() {
        return this.caCount;
    }

    public Integer getConsoleCount() {
        return this.consoleCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaDetails(");
        sb.append("super=").append(super.toString());
        sb.append("proxyCount=").append(String.valueOf(this.proxyCount));
        sb.append(", caCount=").append(String.valueOf(this.caCount));
        sb.append(", consoleCount=").append(String.valueOf(this.consoleCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicaDetails)) {
            return false;
        }
        ReplicaDetails other = (ReplicaDetails)((Object)o);
        return Objects.equals(this.proxyCount, other.proxyCount) && Objects.equals(this.caCount, other.caCount) && Objects.equals(this.consoleCount, other.consoleCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.proxyCount == null ? 43 : this.proxyCount.hashCode());
        result = result * 59 + (this.caCount == null ? 43 : this.caCount.hashCode());
        result = result * 59 + (this.consoleCount == null ? 43 : this.consoleCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="proxyCount")
        private Integer proxyCount;
        @JsonProperty(value="caCount")
        private Integer caCount;
        @JsonProperty(value="consoleCount")
        private Integer consoleCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder proxyCount(Integer proxyCount) {
            this.proxyCount = proxyCount;
            this.__explicitlySet__.add("proxyCount");
            return this;
        }

        public Builder caCount(Integer caCount) {
            this.caCount = caCount;
            this.__explicitlySet__.add("caCount");
            return this;
        }

        public Builder consoleCount(Integer consoleCount) {
            this.consoleCount = consoleCount;
            this.__explicitlySet__.add("consoleCount");
            return this;
        }

        public ReplicaDetails build() {
            ReplicaDetails model = new ReplicaDetails(this.proxyCount, this.caCount, this.consoleCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReplicaDetails model) {
            if (model.wasPropertyExplicitlySet("proxyCount")) {
                this.proxyCount(model.getProxyCount());
            }
            if (model.wasPropertyExplicitlySet("caCount")) {
                this.caCount(model.getCaCount());
            }
            if (model.wasPropertyExplicitlySet("consoleCount")) {
                this.consoleCount(model.getConsoleCount());
            }
            return this;
        }
    }
}

