/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.AvailabilityDomain;
import com.oracle.bmc.blockchain.model.OcpuAllocationNumberParam;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Osn
extends ExplicitlySetBmcModel {
    @JsonProperty(value="osnKey")
    private final String osnKey;
    @JsonProperty(value="ad")
    private final AvailabilityDomain.Ads ad;
    @JsonProperty(value="ocpuAllocationParam")
    private final OcpuAllocationNumberParam ocpuAllocationParam;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"osnKey", "ad", "ocpuAllocationParam", "lifecycleState"})
    public Osn(String osnKey, AvailabilityDomain.Ads ad, OcpuAllocationNumberParam ocpuAllocationParam, LifecycleState lifecycleState) {
        this.osnKey = osnKey;
        this.ad = ad;
        this.ocpuAllocationParam = ocpuAllocationParam;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOsnKey() {
        return this.osnKey;
    }

    public AvailabilityDomain.Ads getAd() {
        return this.ad;
    }

    public OcpuAllocationNumberParam getOcpuAllocationParam() {
        return this.ocpuAllocationParam;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Osn(");
        sb.append("super=").append(super.toString());
        sb.append("osnKey=").append(String.valueOf(this.osnKey));
        sb.append(", ad=").append(String.valueOf((Object)this.ad));
        sb.append(", ocpuAllocationParam=").append(String.valueOf((Object)this.ocpuAllocationParam));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Osn)) {
            return false;
        }
        Osn other = (Osn)((Object)o);
        return Objects.equals(this.osnKey, other.osnKey) && Objects.equals((Object)this.ad, (Object)other.ad) && Objects.equals((Object)this.ocpuAllocationParam, (Object)other.ocpuAllocationParam) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osnKey == null ? 43 : this.osnKey.hashCode());
        result = result * 59 + (this.ad == null ? 43 : this.ad.hashCode());
        result = result * 59 + (this.ocpuAllocationParam == null ? 43 : this.ocpuAllocationParam.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="osnKey")
        private String osnKey;
        @JsonProperty(value="ad")
        private AvailabilityDomain.Ads ad;
        @JsonProperty(value="ocpuAllocationParam")
        private OcpuAllocationNumberParam ocpuAllocationParam;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder osnKey(String osnKey) {
            this.osnKey = osnKey;
            this.__explicitlySet__.add("osnKey");
            return this;
        }

        public Builder ad(AvailabilityDomain.Ads ad) {
            this.ad = ad;
            this.__explicitlySet__.add("ad");
            return this;
        }

        public Builder ocpuAllocationParam(OcpuAllocationNumberParam ocpuAllocationParam) {
            this.ocpuAllocationParam = ocpuAllocationParam;
            this.__explicitlySet__.add("ocpuAllocationParam");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Osn build() {
            Osn model = new Osn(this.osnKey, this.ad, this.ocpuAllocationParam, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Osn model) {
            if (model.wasPropertyExplicitlySet("osnKey")) {
                this.osnKey(model.getOsnKey());
            }
            if (model.wasPropertyExplicitlySet("ad")) {
                this.ad(model.getAd());
            }
            if (model.wasPropertyExplicitlySet("ocpuAllocationParam")) {
                this.ocpuAllocationParam(model.getOcpuAllocationParam());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

