/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.BlockchainPlatformComponentDetails;
import com.oracle.bmc.blockchain.model.OcpuUtilizationInfo;
import com.oracle.bmc.blockchain.model.ReplicaDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockchainPlatform
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="platformVersion")
    private final String platformVersion;
    @JsonProperty(value="serviceVersion")
    private final String serviceVersion;
    @JsonProperty(value="platformRole")
    private final PlatformRole platformRole;
    @JsonProperty(value="computeShape")
    private final ComputeShape computeShape;
    @JsonProperty(value="platformShapeType")
    private final PlatformShapeType platformShapeType;
    @JsonProperty(value="loadBalancerShape")
    private final LoadBalancerShape loadBalancerShape;
    @JsonProperty(value="serviceEndpoint")
    private final String serviceEndpoint;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="storageSizeInTBs")
    private final Double storageSizeInTBs;
    @JsonProperty(value="storageUsedInTBs")
    private final Double storageUsedInTBs;
    @JsonProperty(value="isMultiAD")
    private final Boolean isMultiAD;
    @JsonProperty(value="totalOcpuCapacity")
    private final Integer totalOcpuCapacity;
    @JsonProperty(value="componentDetails")
    private final BlockchainPlatformComponentDetails componentDetails;
    @JsonProperty(value="replicas")
    private final ReplicaDetails replicas;
    @JsonProperty(value="hostOcpuUtilizationInfo")
    private final List<OcpuUtilizationInfo> hostOcpuUtilizationInfo;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "description", "isByol", "timeCreated", "timeUpdated", "platformVersion", "serviceVersion", "platformRole", "computeShape", "platformShapeType", "loadBalancerShape", "serviceEndpoint", "lifecycleState", "lifecycleDetails", "storageSizeInTBs", "storageUsedInTBs", "isMultiAD", "totalOcpuCapacity", "componentDetails", "replicas", "hostOcpuUtilizationInfo", "freeformTags", "definedTags"})
    public BlockchainPlatform(String id, String displayName, String compartmentId, String description, Boolean isByol, Date timeCreated, Date timeUpdated, String platformVersion, String serviceVersion, PlatformRole platformRole, ComputeShape computeShape, PlatformShapeType platformShapeType, LoadBalancerShape loadBalancerShape, String serviceEndpoint, LifecycleState lifecycleState, String lifecycleDetails, Double storageSizeInTBs, Double storageUsedInTBs, Boolean isMultiAD, Integer totalOcpuCapacity, BlockchainPlatformComponentDetails componentDetails, ReplicaDetails replicas, List<OcpuUtilizationInfo> hostOcpuUtilizationInfo, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.description = description;
        this.isByol = isByol;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.platformVersion = platformVersion;
        this.serviceVersion = serviceVersion;
        this.platformRole = platformRole;
        this.computeShape = computeShape;
        this.platformShapeType = platformShapeType;
        this.loadBalancerShape = loadBalancerShape;
        this.serviceEndpoint = serviceEndpoint;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.storageSizeInTBs = storageSizeInTBs;
        this.storageUsedInTBs = storageUsedInTBs;
        this.isMultiAD = isMultiAD;
        this.totalOcpuCapacity = totalOcpuCapacity;
        this.componentDetails = componentDetails;
        this.replicas = replicas;
        this.hostOcpuUtilizationInfo = hostOcpuUtilizationInfo;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public PlatformRole getPlatformRole() {
        return this.platformRole;
    }

    public ComputeShape getComputeShape() {
        return this.computeShape;
    }

    public PlatformShapeType getPlatformShapeType() {
        return this.platformShapeType;
    }

    public LoadBalancerShape getLoadBalancerShape() {
        return this.loadBalancerShape;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Double getStorageSizeInTBs() {
        return this.storageSizeInTBs;
    }

    public Double getStorageUsedInTBs() {
        return this.storageUsedInTBs;
    }

    public Boolean getIsMultiAD() {
        return this.isMultiAD;
    }

    public Integer getTotalOcpuCapacity() {
        return this.totalOcpuCapacity;
    }

    public BlockchainPlatformComponentDetails getComponentDetails() {
        return this.componentDetails;
    }

    public ReplicaDetails getReplicas() {
        return this.replicas;
    }

    public List<OcpuUtilizationInfo> getHostOcpuUtilizationInfo() {
        return this.hostOcpuUtilizationInfo;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockchainPlatform(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isByol=").append(String.valueOf(this.isByol));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", platformVersion=").append(String.valueOf(this.platformVersion));
        sb.append(", serviceVersion=").append(String.valueOf(this.serviceVersion));
        sb.append(", platformRole=").append(String.valueOf((Object)this.platformRole));
        sb.append(", computeShape=").append(String.valueOf((Object)this.computeShape));
        sb.append(", platformShapeType=").append(String.valueOf((Object)this.platformShapeType));
        sb.append(", loadBalancerShape=").append(String.valueOf((Object)this.loadBalancerShape));
        sb.append(", serviceEndpoint=").append(String.valueOf(this.serviceEndpoint));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", storageSizeInTBs=").append(String.valueOf(this.storageSizeInTBs));
        sb.append(", storageUsedInTBs=").append(String.valueOf(this.storageUsedInTBs));
        sb.append(", isMultiAD=").append(String.valueOf(this.isMultiAD));
        sb.append(", totalOcpuCapacity=").append(String.valueOf(this.totalOcpuCapacity));
        sb.append(", componentDetails=").append(String.valueOf((Object)this.componentDetails));
        sb.append(", replicas=").append(String.valueOf((Object)this.replicas));
        sb.append(", hostOcpuUtilizationInfo=").append(String.valueOf(this.hostOcpuUtilizationInfo));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockchainPlatform)) {
            return false;
        }
        BlockchainPlatform other = (BlockchainPlatform)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.isByol, other.isByol) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.platformVersion, other.platformVersion) && Objects.equals(this.serviceVersion, other.serviceVersion) && Objects.equals((Object)this.platformRole, (Object)other.platformRole) && Objects.equals((Object)this.computeShape, (Object)other.computeShape) && Objects.equals((Object)this.platformShapeType, (Object)other.platformShapeType) && Objects.equals((Object)this.loadBalancerShape, (Object)other.loadBalancerShape) && Objects.equals(this.serviceEndpoint, other.serviceEndpoint) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.storageSizeInTBs, other.storageSizeInTBs) && Objects.equals(this.storageUsedInTBs, other.storageUsedInTBs) && Objects.equals(this.isMultiAD, other.isMultiAD) && Objects.equals(this.totalOcpuCapacity, other.totalOcpuCapacity) && Objects.equals((Object)this.componentDetails, (Object)other.componentDetails) && Objects.equals((Object)this.replicas, (Object)other.replicas) && Objects.equals(this.hostOcpuUtilizationInfo, other.hostOcpuUtilizationInfo) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isByol == null ? 43 : this.isByol.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.platformVersion == null ? 43 : this.platformVersion.hashCode());
        result = result * 59 + (this.serviceVersion == null ? 43 : this.serviceVersion.hashCode());
        result = result * 59 + (this.platformRole == null ? 43 : this.platformRole.hashCode());
        result = result * 59 + (this.computeShape == null ? 43 : this.computeShape.hashCode());
        result = result * 59 + (this.platformShapeType == null ? 43 : this.platformShapeType.hashCode());
        result = result * 59 + (this.loadBalancerShape == null ? 43 : this.loadBalancerShape.hashCode());
        result = result * 59 + (this.serviceEndpoint == null ? 43 : this.serviceEndpoint.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.storageSizeInTBs == null ? 43 : this.storageSizeInTBs.hashCode());
        result = result * 59 + (this.storageUsedInTBs == null ? 43 : this.storageUsedInTBs.hashCode());
        result = result * 59 + (this.isMultiAD == null ? 43 : this.isMultiAD.hashCode());
        result = result * 59 + (this.totalOcpuCapacity == null ? 43 : this.totalOcpuCapacity.hashCode());
        result = result * 59 + (this.componentDetails == null ? 43 : this.componentDetails.hashCode());
        result = result * 59 + (this.replicas == null ? 43 : this.replicas.hashCode());
        result = result * 59 + (this.hostOcpuUtilizationInfo == null ? 43 : this.hostOcpuUtilizationInfo.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Scaling("SCALING"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LoadBalancerShape implements BmcEnum
    {
        Lb100Mbps("LB_100_MBPS"),
        Lb400Mbps("LB_400_MBPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LoadBalancerShape> map;

        private LoadBalancerShape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LoadBalancerShape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LoadBalancerShape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LoadBalancerShape.class);
            map = new HashMap<String, LoadBalancerShape>();
            for (LoadBalancerShape v : LoadBalancerShape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformShapeType implements BmcEnum
    {
        Default("DEFAULT"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformShapeType> map;

        private PlatformShapeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformShapeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformShapeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformShapeType.class);
            map = new HashMap<String, PlatformShapeType>();
            for (PlatformShapeType v : PlatformShapeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeShape implements BmcEnum
    {
        Standard("STANDARD"),
        EnterpriseSmall("ENTERPRISE_SMALL"),
        EnterpriseMedium("ENTERPRISE_MEDIUM"),
        EnterpriseLarge("ENTERPRISE_LARGE"),
        EnterpriseExtraLarge("ENTERPRISE_EXTRA_LARGE"),
        EnterpriseCustom("ENTERPRISE_CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeShape> map;

        private ComputeShape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeShape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeShape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeShape.class);
            map = new HashMap<String, ComputeShape>();
            for (ComputeShape v : ComputeShape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlatformRole implements BmcEnum
    {
        Founder("FOUNDER"),
        Participant("PARTICIPANT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlatformRole> map;

        private PlatformRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlatformRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlatformRole.class);
            map = new HashMap<String, PlatformRole>();
            for (PlatformRole v : PlatformRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="platformVersion")
        private String platformVersion;
        @JsonProperty(value="serviceVersion")
        private String serviceVersion;
        @JsonProperty(value="platformRole")
        private PlatformRole platformRole;
        @JsonProperty(value="computeShape")
        private ComputeShape computeShape;
        @JsonProperty(value="platformShapeType")
        private PlatformShapeType platformShapeType;
        @JsonProperty(value="loadBalancerShape")
        private LoadBalancerShape loadBalancerShape;
        @JsonProperty(value="serviceEndpoint")
        private String serviceEndpoint;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="storageSizeInTBs")
        private Double storageSizeInTBs;
        @JsonProperty(value="storageUsedInTBs")
        private Double storageUsedInTBs;
        @JsonProperty(value="isMultiAD")
        private Boolean isMultiAD;
        @JsonProperty(value="totalOcpuCapacity")
        private Integer totalOcpuCapacity;
        @JsonProperty(value="componentDetails")
        private BlockchainPlatformComponentDetails componentDetails;
        @JsonProperty(value="replicas")
        private ReplicaDetails replicas;
        @JsonProperty(value="hostOcpuUtilizationInfo")
        private List<OcpuUtilizationInfo> hostOcpuUtilizationInfo;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            this.__explicitlySet__.add("platformVersion");
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            this.__explicitlySet__.add("serviceVersion");
            return this;
        }

        public Builder platformRole(PlatformRole platformRole) {
            this.platformRole = platformRole;
            this.__explicitlySet__.add("platformRole");
            return this;
        }

        public Builder computeShape(ComputeShape computeShape) {
            this.computeShape = computeShape;
            this.__explicitlySet__.add("computeShape");
            return this;
        }

        public Builder platformShapeType(PlatformShapeType platformShapeType) {
            this.platformShapeType = platformShapeType;
            this.__explicitlySet__.add("platformShapeType");
            return this;
        }

        public Builder loadBalancerShape(LoadBalancerShape loadBalancerShape) {
            this.loadBalancerShape = loadBalancerShape;
            this.__explicitlySet__.add("loadBalancerShape");
            return this;
        }

        public Builder serviceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            this.__explicitlySet__.add("serviceEndpoint");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder storageSizeInTBs(Double storageSizeInTBs) {
            this.storageSizeInTBs = storageSizeInTBs;
            this.__explicitlySet__.add("storageSizeInTBs");
            return this;
        }

        public Builder storageUsedInTBs(Double storageUsedInTBs) {
            this.storageUsedInTBs = storageUsedInTBs;
            this.__explicitlySet__.add("storageUsedInTBs");
            return this;
        }

        public Builder isMultiAD(Boolean isMultiAD) {
            this.isMultiAD = isMultiAD;
            this.__explicitlySet__.add("isMultiAD");
            return this;
        }

        public Builder totalOcpuCapacity(Integer totalOcpuCapacity) {
            this.totalOcpuCapacity = totalOcpuCapacity;
            this.__explicitlySet__.add("totalOcpuCapacity");
            return this;
        }

        public Builder componentDetails(BlockchainPlatformComponentDetails componentDetails) {
            this.componentDetails = componentDetails;
            this.__explicitlySet__.add("componentDetails");
            return this;
        }

        public Builder replicas(ReplicaDetails replicas) {
            this.replicas = replicas;
            this.__explicitlySet__.add("replicas");
            return this;
        }

        public Builder hostOcpuUtilizationInfo(List<OcpuUtilizationInfo> hostOcpuUtilizationInfo) {
            this.hostOcpuUtilizationInfo = hostOcpuUtilizationInfo;
            this.__explicitlySet__.add("hostOcpuUtilizationInfo");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public BlockchainPlatform build() {
            BlockchainPlatform model = new BlockchainPlatform(this.id, this.displayName, this.compartmentId, this.description, this.isByol, this.timeCreated, this.timeUpdated, this.platformVersion, this.serviceVersion, this.platformRole, this.computeShape, this.platformShapeType, this.loadBalancerShape, this.serviceEndpoint, this.lifecycleState, this.lifecycleDetails, this.storageSizeInTBs, this.storageUsedInTBs, this.isMultiAD, this.totalOcpuCapacity, this.componentDetails, this.replicas, this.hostOcpuUtilizationInfo, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockchainPlatform model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isByol")) {
                this.isByol(model.getIsByol());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("platformVersion")) {
                this.platformVersion(model.getPlatformVersion());
            }
            if (model.wasPropertyExplicitlySet("serviceVersion")) {
                this.serviceVersion(model.getServiceVersion());
            }
            if (model.wasPropertyExplicitlySet("platformRole")) {
                this.platformRole(model.getPlatformRole());
            }
            if (model.wasPropertyExplicitlySet("computeShape")) {
                this.computeShape(model.getComputeShape());
            }
            if (model.wasPropertyExplicitlySet("platformShapeType")) {
                this.platformShapeType(model.getPlatformShapeType());
            }
            if (model.wasPropertyExplicitlySet("loadBalancerShape")) {
                this.loadBalancerShape(model.getLoadBalancerShape());
            }
            if (model.wasPropertyExplicitlySet("serviceEndpoint")) {
                this.serviceEndpoint(model.getServiceEndpoint());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("storageSizeInTBs")) {
                this.storageSizeInTBs(model.getStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("storageUsedInTBs")) {
                this.storageUsedInTBs(model.getStorageUsedInTBs());
            }
            if (model.wasPropertyExplicitlySet("isMultiAD")) {
                this.isMultiAD(model.getIsMultiAD());
            }
            if (model.wasPropertyExplicitlySet("totalOcpuCapacity")) {
                this.totalOcpuCapacity(model.getTotalOcpuCapacity());
            }
            if (model.wasPropertyExplicitlySet("componentDetails")) {
                this.componentDetails(model.getComponentDetails());
            }
            if (model.wasPropertyExplicitlySet("replicas")) {
                this.replicas(model.getReplicas());
            }
            if (model.wasPropertyExplicitlySet("hostOcpuUtilizationInfo")) {
                this.hostOcpuUtilizationInfo(model.getHostOcpuUtilizationInfo());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

