/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.oracle.bmc.blockchain.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.BlockchainPlatformPatchSummary;
import com.oracle.bmc.blockchain.model.BlockchainPlatformSummary;
import com.oracle.bmc.blockchain.model.OsnSummary;
import com.oracle.bmc.blockchain.model.PeerSummary;
import com.oracle.bmc.blockchain.model.WorkRequestError;
import com.oracle.bmc.blockchain.model.WorkRequestLogEntry;
import com.oracle.bmc.blockchain.model.WorkRequestSummary;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformPatchesRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformPatchesResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BlockchainPlatformPaginators {
    private final BlockchainPlatform client;

    public BlockchainPlatformPaginators(BlockchainPlatform client) {
        this.client = client;
    }

    public Iterable<ListBlockchainPlatformPatchesResponse> listBlockchainPlatformPatchesResponseIterator(final ListBlockchainPlatformPatchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBlockchainPlatformPatchesRequest.Builder>(){

            @Override
            public ListBlockchainPlatformPatchesRequest.Builder get() {
                return ListBlockchainPlatformPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlockchainPlatformPatchesResponse, String>(){

            @Override
            public String apply(ListBlockchainPlatformPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlockchainPlatformPatchesRequest.Builder>, ListBlockchainPlatformPatchesRequest>(){

            @Override
            public ListBlockchainPlatformPatchesRequest apply(RequestBuilderAndToken<ListBlockchainPlatformPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlockchainPlatformPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlockchainPlatformPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlockchainPlatformPatchesRequest, ListBlockchainPlatformPatchesResponse>(){

            @Override
            public ListBlockchainPlatformPatchesResponse apply(ListBlockchainPlatformPatchesRequest request) {
                return BlockchainPlatformPaginators.this.client.listBlockchainPlatformPatches(request);
            }
        });
    }

    public Iterable<BlockchainPlatformPatchSummary> listBlockchainPlatformPatchesRecordIterator(final ListBlockchainPlatformPatchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBlockchainPlatformPatchesRequest.Builder>(){

            @Override
            public ListBlockchainPlatformPatchesRequest.Builder get() {
                return ListBlockchainPlatformPatchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlockchainPlatformPatchesResponse, String>(){

            @Override
            public String apply(ListBlockchainPlatformPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlockchainPlatformPatchesRequest.Builder>, ListBlockchainPlatformPatchesRequest>(){

            @Override
            public ListBlockchainPlatformPatchesRequest apply(RequestBuilderAndToken<ListBlockchainPlatformPatchesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlockchainPlatformPatchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlockchainPlatformPatchesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlockchainPlatformPatchesRequest, ListBlockchainPlatformPatchesResponse>(){

            @Override
            public ListBlockchainPlatformPatchesResponse apply(ListBlockchainPlatformPatchesRequest request) {
                return BlockchainPlatformPaginators.this.client.listBlockchainPlatformPatches(request);
            }
        }, (Function)new Function<ListBlockchainPlatformPatchesResponse, List<BlockchainPlatformPatchSummary>>(){

            @Override
            public List<BlockchainPlatformPatchSummary> apply(ListBlockchainPlatformPatchesResponse response) {
                return response.getBlockchainPlatformPatchCollection().getItems();
            }
        });
    }

    public Iterable<ListBlockchainPlatformsResponse> listBlockchainPlatformsResponseIterator(final ListBlockchainPlatformsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBlockchainPlatformsRequest.Builder>(){

            @Override
            public ListBlockchainPlatformsRequest.Builder get() {
                return ListBlockchainPlatformsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlockchainPlatformsResponse, String>(){

            @Override
            public String apply(ListBlockchainPlatformsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlockchainPlatformsRequest.Builder>, ListBlockchainPlatformsRequest>(){

            @Override
            public ListBlockchainPlatformsRequest apply(RequestBuilderAndToken<ListBlockchainPlatformsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlockchainPlatformsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlockchainPlatformsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse>(){

            @Override
            public ListBlockchainPlatformsResponse apply(ListBlockchainPlatformsRequest request) {
                return BlockchainPlatformPaginators.this.client.listBlockchainPlatforms(request);
            }
        });
    }

    public Iterable<BlockchainPlatformSummary> listBlockchainPlatformsRecordIterator(final ListBlockchainPlatformsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBlockchainPlatformsRequest.Builder>(){

            @Override
            public ListBlockchainPlatformsRequest.Builder get() {
                return ListBlockchainPlatformsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlockchainPlatformsResponse, String>(){

            @Override
            public String apply(ListBlockchainPlatformsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlockchainPlatformsRequest.Builder>, ListBlockchainPlatformsRequest>(){

            @Override
            public ListBlockchainPlatformsRequest apply(RequestBuilderAndToken<ListBlockchainPlatformsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlockchainPlatformsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlockchainPlatformsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse>(){

            @Override
            public ListBlockchainPlatformsResponse apply(ListBlockchainPlatformsRequest request) {
                return BlockchainPlatformPaginators.this.client.listBlockchainPlatforms(request);
            }
        }, (Function)new Function<ListBlockchainPlatformsResponse, List<BlockchainPlatformSummary>>(){

            @Override
            public List<BlockchainPlatformSummary> apply(ListBlockchainPlatformsResponse response) {
                return response.getBlockchainPlatformCollection().getItems();
            }
        });
    }

    public Iterable<ListOsnsResponse> listOsnsResponseIterator(final ListOsnsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOsnsRequest.Builder>(){

            @Override
            public ListOsnsRequest.Builder get() {
                return ListOsnsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOsnsResponse, String>(){

            @Override
            public String apply(ListOsnsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOsnsRequest.Builder>, ListOsnsRequest>(){

            @Override
            public ListOsnsRequest apply(RequestBuilderAndToken<ListOsnsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOsnsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOsnsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOsnsRequest, ListOsnsResponse>(){

            @Override
            public ListOsnsResponse apply(ListOsnsRequest request) {
                return BlockchainPlatformPaginators.this.client.listOsns(request);
            }
        });
    }

    public Iterable<OsnSummary> listOsnsRecordIterator(final ListOsnsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOsnsRequest.Builder>(){

            @Override
            public ListOsnsRequest.Builder get() {
                return ListOsnsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOsnsResponse, String>(){

            @Override
            public String apply(ListOsnsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOsnsRequest.Builder>, ListOsnsRequest>(){

            @Override
            public ListOsnsRequest apply(RequestBuilderAndToken<ListOsnsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOsnsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOsnsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOsnsRequest, ListOsnsResponse>(){

            @Override
            public ListOsnsResponse apply(ListOsnsRequest request) {
                return BlockchainPlatformPaginators.this.client.listOsns(request);
            }
        }, (Function)new Function<ListOsnsResponse, List<OsnSummary>>(){

            @Override
            public List<OsnSummary> apply(ListOsnsResponse response) {
                return response.getOsnCollection().getItems();
            }
        });
    }

    public Iterable<ListPeersResponse> listPeersResponseIterator(final ListPeersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPeersRequest.Builder>(){

            @Override
            public ListPeersRequest.Builder get() {
                return ListPeersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPeersResponse, String>(){

            @Override
            public String apply(ListPeersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPeersRequest.Builder>, ListPeersRequest>(){

            @Override
            public ListPeersRequest apply(RequestBuilderAndToken<ListPeersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPeersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPeersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPeersRequest, ListPeersResponse>(){

            @Override
            public ListPeersResponse apply(ListPeersRequest request) {
                return BlockchainPlatformPaginators.this.client.listPeers(request);
            }
        });
    }

    public Iterable<PeerSummary> listPeersRecordIterator(final ListPeersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPeersRequest.Builder>(){

            @Override
            public ListPeersRequest.Builder get() {
                return ListPeersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPeersResponse, String>(){

            @Override
            public String apply(ListPeersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPeersRequest.Builder>, ListPeersRequest>(){

            @Override
            public ListPeersRequest apply(RequestBuilderAndToken<ListPeersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPeersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPeersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPeersRequest, ListPeersResponse>(){

            @Override
            public ListPeersResponse apply(ListPeersRequest request) {
                return BlockchainPlatformPaginators.this.client.listPeers(request);
            }
        }, (Function)new Function<ListPeersResponse, List<PeerSummary>>(){

            @Override
            public List<PeerSummary> apply(ListPeersResponse response) {
                return response.getPeerCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BlockchainPlatformPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

