/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.bds.model.BdsApiKey;
import com.oracle.bmc.bds.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListBdsApiKeysRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private BdsApiKey.LifecycleState lifecycleState;
    private String userId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String displayName;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public BdsApiKey.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).lifecycleState(this.lifecycleState).userId(this.userId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).displayName(this.displayName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBdsApiKeysRequest)) {
            return false;
        }
        ListBdsApiKeysRequest other = (ListBdsApiKeysRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.userId, other.userId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBdsApiKeysRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private BdsApiKey.LifecycleState lifecycleState = null;
        private String userId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String displayName = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder lifecycleState(BdsApiKey.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBdsApiKeysRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.lifecycleState(o.getLifecycleState());
            this.userId(o.getUserId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBdsApiKeysRequest build() {
            ListBdsApiKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListBdsApiKeysRequest buildWithoutInvocationCallback() {
            ListBdsApiKeysRequest request = new ListBdsApiKeysRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.lifecycleState = this.lifecycleState;
            request.userId = this.userId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.displayName = this.displayName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

