/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAutoScalingConfigurationRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String autoScalingConfigurationId;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getAutoScalingConfigurationId() {
        return this.autoScalingConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).autoScalingConfigurationId(this.autoScalingConfigurationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",autoScalingConfigurationId=").append(String.valueOf(this.autoScalingConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAutoScalingConfigurationRequest)) {
            return false;
        }
        GetAutoScalingConfigurationRequest other = (GetAutoScalingConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals(this.autoScalingConfigurationId, other.autoScalingConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.autoScalingConfigurationId == null ? 43 : this.autoScalingConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutoScalingConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private String autoScalingConfigurationId = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder autoScalingConfigurationId(String autoScalingConfigurationId) {
            this.autoScalingConfigurationId = autoScalingConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutoScalingConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.autoScalingConfigurationId(o.getAutoScalingConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutoScalingConfigurationRequest build() {
            GetAutoScalingConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAutoScalingConfigurationRequest buildWithoutInvocationCallback() {
            GetAutoScalingConfigurationRequest request = new GetAutoScalingConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.autoScalingConfigurationId = this.autoScalingConfigurationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

