/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyMetricRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricBasedHorizontalScaleInConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metric")
    private final AutoScalePolicyMetricRule metric;
    @JsonProperty(value="minNodeCount")
    private final Integer minNodeCount;
    @JsonProperty(value="stepSize")
    private final Integer stepSize;

    @Deprecated
    @ConstructorProperties(value={"metric", "minNodeCount", "stepSize"})
    public MetricBasedHorizontalScaleInConfig(AutoScalePolicyMetricRule metric, Integer minNodeCount, Integer stepSize) {
        this.metric = metric;
        this.minNodeCount = minNodeCount;
        this.stepSize = stepSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutoScalePolicyMetricRule getMetric() {
        return this.metric;
    }

    public Integer getMinNodeCount() {
        return this.minNodeCount;
    }

    public Integer getStepSize() {
        return this.stepSize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricBasedHorizontalScaleInConfig(");
        sb.append("super=").append(super.toString());
        sb.append("metric=").append(String.valueOf((Object)this.metric));
        sb.append(", minNodeCount=").append(String.valueOf(this.minNodeCount));
        sb.append(", stepSize=").append(String.valueOf(this.stepSize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricBasedHorizontalScaleInConfig)) {
            return false;
        }
        MetricBasedHorizontalScaleInConfig other = (MetricBasedHorizontalScaleInConfig)((Object)o);
        return Objects.equals((Object)this.metric, (Object)other.metric) && Objects.equals(this.minNodeCount, other.minNodeCount) && Objects.equals(this.stepSize, other.stepSize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metric == null ? 43 : this.metric.hashCode());
        result = result * 59 + (this.minNodeCount == null ? 43 : this.minNodeCount.hashCode());
        result = result * 59 + (this.stepSize == null ? 43 : this.stepSize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metric")
        private AutoScalePolicyMetricRule metric;
        @JsonProperty(value="minNodeCount")
        private Integer minNodeCount;
        @JsonProperty(value="stepSize")
        private Integer stepSize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metric(AutoScalePolicyMetricRule metric) {
            this.metric = metric;
            this.__explicitlySet__.add("metric");
            return this;
        }

        public Builder minNodeCount(Integer minNodeCount) {
            this.minNodeCount = minNodeCount;
            this.__explicitlySet__.add("minNodeCount");
            return this;
        }

        public Builder stepSize(Integer stepSize) {
            this.stepSize = stepSize;
            this.__explicitlySet__.add("stepSize");
            return this;
        }

        public MetricBasedHorizontalScaleInConfig build() {
            MetricBasedHorizontalScaleInConfig model = new MetricBasedHorizontalScaleInConfig(this.metric, this.minNodeCount, this.stepSize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricBasedHorizontalScaleInConfig model) {
            if (model.wasPropertyExplicitlySet("metric")) {
                this.metric(model.getMetric());
            }
            if (model.wasPropertyExplicitlySet("minNodeCount")) {
                this.minNodeCount(model.getMinNodeCount());
            }
            if (model.wasPropertyExplicitlySet("stepSize")) {
                this.stepSize(model.getStepSize());
            }
            return this;
        }
    }
}

