/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.Node;
import com.oracle.bmc.bds.model.ShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateNodeDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="nodeType")
    private final Node.NodeType nodeType;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="blockVolumeSizeInGBs")
    private final Long blockVolumeSizeInGBs;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="shapeConfig")
    private final ShapeConfigDetails shapeConfig;

    @Deprecated
    @ConstructorProperties(value={"nodeType", "shape", "blockVolumeSizeInGBs", "subnetId", "shapeConfig"})
    public CreateNodeDetails(Node.NodeType nodeType, String shape, Long blockVolumeSizeInGBs, String subnetId, ShapeConfigDetails shapeConfig) {
        this.nodeType = nodeType;
        this.shape = shape;
        this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
        this.subnetId = subnetId;
        this.shapeConfig = shapeConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Node.NodeType getNodeType() {
        return this.nodeType;
    }

    public String getShape() {
        return this.shape;
    }

    public Long getBlockVolumeSizeInGBs() {
        return this.blockVolumeSizeInGBs;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public ShapeConfigDetails getShapeConfig() {
        return this.shapeConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateNodeDetails(");
        sb.append("super=").append(super.toString());
        sb.append("nodeType=").append(String.valueOf((Object)this.nodeType));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", blockVolumeSizeInGBs=").append(String.valueOf(this.blockVolumeSizeInGBs));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNodeDetails)) {
            return false;
        }
        CreateNodeDetails other = (CreateNodeDetails)((Object)o);
        return Objects.equals((Object)this.nodeType, (Object)other.nodeType) && Objects.equals(this.shape, other.shape) && Objects.equals(this.blockVolumeSizeInGBs, other.blockVolumeSizeInGBs) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nodeType == null ? 43 : this.nodeType.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.blockVolumeSizeInGBs == null ? 43 : this.blockVolumeSizeInGBs.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="nodeType")
        private Node.NodeType nodeType;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="blockVolumeSizeInGBs")
        private Long blockVolumeSizeInGBs;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="shapeConfig")
        private ShapeConfigDetails shapeConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder nodeType(Node.NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder blockVolumeSizeInGBs(Long blockVolumeSizeInGBs) {
            this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
            this.__explicitlySet__.add("blockVolumeSizeInGBs");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder shapeConfig(ShapeConfigDetails shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public CreateNodeDetails build() {
            CreateNodeDetails model = new CreateNodeDetails(this.nodeType, this.shape, this.blockVolumeSizeInGBs, this.subnetId, this.shapeConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateNodeDetails model) {
            if (model.wasPropertyExplicitlySet("nodeType")) {
                this.nodeType(model.getNodeType());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeSizeInGBs")) {
                this.blockVolumeSizeInGBs(model.getBlockVolumeSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            return this;
        }
    }
}

