/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateBdsApiKeyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="passphrase")
    private final String passphrase;
    @JsonProperty(value="defaultRegion")
    private final String defaultRegion;
    @JsonProperty(value="keyAlias")
    private final String keyAlias;

    @Deprecated
    @ConstructorProperties(value={"userId", "passphrase", "defaultRegion", "keyAlias"})
    public CreateBdsApiKeyDetails(String userId, String passphrase, String defaultRegion, String keyAlias) {
        this.userId = userId;
        this.passphrase = passphrase;
        this.defaultRegion = defaultRegion;
        this.keyAlias = keyAlias;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBdsApiKeyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("userId=").append(String.valueOf(this.userId));
        sb.append(", passphrase=").append("<redacted>");
        sb.append(", defaultRegion=").append(String.valueOf(this.defaultRegion));
        sb.append(", keyAlias=").append(String.valueOf(this.keyAlias));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBdsApiKeyDetails)) {
            return false;
        }
        CreateBdsApiKeyDetails other = (CreateBdsApiKeyDetails)((Object)o);
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.passphrase, other.passphrase) && Objects.equals(this.defaultRegion, other.defaultRegion) && Objects.equals(this.keyAlias, other.keyAlias) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.passphrase == null ? 43 : this.passphrase.hashCode());
        result = result * 59 + (this.defaultRegion == null ? 43 : this.defaultRegion.hashCode());
        result = result * 59 + (this.keyAlias == null ? 43 : this.keyAlias.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="passphrase")
        private String passphrase;
        @JsonProperty(value="defaultRegion")
        private String defaultRegion;
        @JsonProperty(value="keyAlias")
        private String keyAlias;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder passphrase(String passphrase) {
            this.passphrase = passphrase;
            this.__explicitlySet__.add("passphrase");
            return this;
        }

        public Builder defaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
            this.__explicitlySet__.add("defaultRegion");
            return this;
        }

        public Builder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            this.__explicitlySet__.add("keyAlias");
            return this;
        }

        public CreateBdsApiKeyDetails build() {
            CreateBdsApiKeyDetails model = new CreateBdsApiKeyDetails(this.userId, this.passphrase, this.defaultRegion, this.keyAlias);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBdsApiKeyDetails model) {
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("passphrase")) {
                this.passphrase(model.getPassphrase());
            }
            if (model.wasPropertyExplicitlySet("defaultRegion")) {
                this.defaultRegion(model.getDefaultRegion());
            }
            if (model.wasPropertyExplicitlySet("keyAlias")) {
                this.keyAlias(model.getKeyAlias());
            }
            return this;
        }
    }
}

