/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.CloudSqlDetails;
import com.oracle.bmc.bds.model.ClusterDetails;
import com.oracle.bmc.bds.model.NetworkConfig;
import com.oracle.bmc.bds.model.Node;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BdsInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="clusterVersion")
    private final ClusterVersion clusterVersion;
    @JsonProperty(value="isHighAvailability")
    private final Boolean isHighAvailability;
    @JsonProperty(value="isSecure")
    private final Boolean isSecure;
    @JsonProperty(value="isCloudSqlConfigured")
    private final Boolean isCloudSqlConfigured;
    @JsonProperty(value="networkConfig")
    private final NetworkConfig networkConfig;
    @JsonProperty(value="clusterDetails")
    private final ClusterDetails clusterDetails;
    @JsonProperty(value="nodes")
    private final List<Node> nodes;
    @JsonProperty(value="cloudSqlDetails")
    private final CloudSqlDetails cloudSqlDetails;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="numberOfNodes")
    private final Integer numberOfNodes;
    @JsonProperty(value="bootstrapScriptUrl")
    private final String bootstrapScriptUrl;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "lifecycleState", "clusterVersion", "isHighAvailability", "isSecure", "isCloudSqlConfigured", "networkConfig", "clusterDetails", "nodes", "cloudSqlDetails", "createdBy", "timeCreated", "timeUpdated", "numberOfNodes", "bootstrapScriptUrl", "freeformTags", "definedTags", "kmsKeyId"})
    public BdsInstance(String id, String compartmentId, String displayName, LifecycleState lifecycleState, ClusterVersion clusterVersion, Boolean isHighAvailability, Boolean isSecure, Boolean isCloudSqlConfigured, NetworkConfig networkConfig, ClusterDetails clusterDetails, List<Node> nodes, CloudSqlDetails cloudSqlDetails, String createdBy, Date timeCreated, Date timeUpdated, Integer numberOfNodes, String bootstrapScriptUrl, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String kmsKeyId) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.clusterVersion = clusterVersion;
        this.isHighAvailability = isHighAvailability;
        this.isSecure = isSecure;
        this.isCloudSqlConfigured = isCloudSqlConfigured;
        this.networkConfig = networkConfig;
        this.clusterDetails = clusterDetails;
        this.nodes = nodes;
        this.cloudSqlDetails = cloudSqlDetails;
        this.createdBy = createdBy;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.numberOfNodes = numberOfNodes;
        this.bootstrapScriptUrl = bootstrapScriptUrl;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.kmsKeyId = kmsKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ClusterVersion getClusterVersion() {
        return this.clusterVersion;
    }

    public Boolean getIsHighAvailability() {
        return this.isHighAvailability;
    }

    public Boolean getIsSecure() {
        return this.isSecure;
    }

    public Boolean getIsCloudSqlConfigured() {
        return this.isCloudSqlConfigured;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public ClusterDetails getClusterDetails() {
        return this.clusterDetails;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public CloudSqlDetails getCloudSqlDetails() {
        return this.cloudSqlDetails;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public String getBootstrapScriptUrl() {
        return this.bootstrapScriptUrl;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BdsInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", clusterVersion=").append(String.valueOf((Object)this.clusterVersion));
        sb.append(", isHighAvailability=").append(String.valueOf(this.isHighAvailability));
        sb.append(", isSecure=").append(String.valueOf(this.isSecure));
        sb.append(", isCloudSqlConfigured=").append(String.valueOf(this.isCloudSqlConfigured));
        sb.append(", networkConfig=").append(String.valueOf((Object)this.networkConfig));
        sb.append(", clusterDetails=").append(String.valueOf((Object)this.clusterDetails));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", cloudSqlDetails=").append(String.valueOf((Object)this.cloudSqlDetails));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", numberOfNodes=").append(String.valueOf(this.numberOfNodes));
        sb.append(", bootstrapScriptUrl=").append(String.valueOf(this.bootstrapScriptUrl));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BdsInstance)) {
            return false;
        }
        BdsInstance other = (BdsInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.clusterVersion, (Object)other.clusterVersion) && Objects.equals(this.isHighAvailability, other.isHighAvailability) && Objects.equals(this.isSecure, other.isSecure) && Objects.equals(this.isCloudSqlConfigured, other.isCloudSqlConfigured) && Objects.equals((Object)this.networkConfig, (Object)other.networkConfig) && Objects.equals((Object)this.clusterDetails, (Object)other.clusterDetails) && Objects.equals(this.nodes, other.nodes) && Objects.equals((Object)this.cloudSqlDetails, (Object)other.cloudSqlDetails) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.numberOfNodes, other.numberOfNodes) && Objects.equals(this.bootstrapScriptUrl, other.bootstrapScriptUrl) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.clusterVersion == null ? 43 : this.clusterVersion.hashCode());
        result = result * 59 + (this.isHighAvailability == null ? 43 : this.isHighAvailability.hashCode());
        result = result * 59 + (this.isSecure == null ? 43 : this.isSecure.hashCode());
        result = result * 59 + (this.isCloudSqlConfigured == null ? 43 : this.isCloudSqlConfigured.hashCode());
        result = result * 59 + (this.networkConfig == null ? 43 : this.networkConfig.hashCode());
        result = result * 59 + (this.clusterDetails == null ? 43 : this.clusterDetails.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.cloudSqlDetails == null ? 43 : this.cloudSqlDetails.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.numberOfNodes == null ? 43 : this.numberOfNodes.hashCode());
        result = result * 59 + (this.bootstrapScriptUrl == null ? 43 : this.bootstrapScriptUrl.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ClusterVersion implements BmcEnum
    {
        Cdh5("CDH5"),
        Cdh6("CDH6"),
        Odh1("ODH1"),
        Odh09("ODH0_9"),
        Odh20("ODH2_0"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ClusterVersion> map;

        private ClusterVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ClusterVersion create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ClusterVersion', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ClusterVersion.class);
            map = new HashMap<String, ClusterVersion>();
            for (ClusterVersion v : ClusterVersion.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Updating("UPDATING"),
        Suspending("SUSPENDING"),
        Suspended("SUSPENDED"),
        Resuming("RESUMING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="clusterVersion")
        private ClusterVersion clusterVersion;
        @JsonProperty(value="isHighAvailability")
        private Boolean isHighAvailability;
        @JsonProperty(value="isSecure")
        private Boolean isSecure;
        @JsonProperty(value="isCloudSqlConfigured")
        private Boolean isCloudSqlConfigured;
        @JsonProperty(value="networkConfig")
        private NetworkConfig networkConfig;
        @JsonProperty(value="clusterDetails")
        private ClusterDetails clusterDetails;
        @JsonProperty(value="nodes")
        private List<Node> nodes;
        @JsonProperty(value="cloudSqlDetails")
        private CloudSqlDetails cloudSqlDetails;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="numberOfNodes")
        private Integer numberOfNodes;
        @JsonProperty(value="bootstrapScriptUrl")
        private String bootstrapScriptUrl;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder clusterVersion(ClusterVersion clusterVersion) {
            this.clusterVersion = clusterVersion;
            this.__explicitlySet__.add("clusterVersion");
            return this;
        }

        public Builder isHighAvailability(Boolean isHighAvailability) {
            this.isHighAvailability = isHighAvailability;
            this.__explicitlySet__.add("isHighAvailability");
            return this;
        }

        public Builder isSecure(Boolean isSecure) {
            this.isSecure = isSecure;
            this.__explicitlySet__.add("isSecure");
            return this;
        }

        public Builder isCloudSqlConfigured(Boolean isCloudSqlConfigured) {
            this.isCloudSqlConfigured = isCloudSqlConfigured;
            this.__explicitlySet__.add("isCloudSqlConfigured");
            return this;
        }

        public Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            this.__explicitlySet__.add("networkConfig");
            return this;
        }

        public Builder clusterDetails(ClusterDetails clusterDetails) {
            this.clusterDetails = clusterDetails;
            this.__explicitlySet__.add("clusterDetails");
            return this;
        }

        public Builder nodes(List<Node> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder cloudSqlDetails(CloudSqlDetails cloudSqlDetails) {
            this.cloudSqlDetails = cloudSqlDetails;
            this.__explicitlySet__.add("cloudSqlDetails");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            this.__explicitlySet__.add("numberOfNodes");
            return this;
        }

        public Builder bootstrapScriptUrl(String bootstrapScriptUrl) {
            this.bootstrapScriptUrl = bootstrapScriptUrl;
            this.__explicitlySet__.add("bootstrapScriptUrl");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public BdsInstance build() {
            BdsInstance model = new BdsInstance(this.id, this.compartmentId, this.displayName, this.lifecycleState, this.clusterVersion, this.isHighAvailability, this.isSecure, this.isCloudSqlConfigured, this.networkConfig, this.clusterDetails, this.nodes, this.cloudSqlDetails, this.createdBy, this.timeCreated, this.timeUpdated, this.numberOfNodes, this.bootstrapScriptUrl, this.freeformTags, this.definedTags, this.kmsKeyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BdsInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("clusterVersion")) {
                this.clusterVersion(model.getClusterVersion());
            }
            if (model.wasPropertyExplicitlySet("isHighAvailability")) {
                this.isHighAvailability(model.getIsHighAvailability());
            }
            if (model.wasPropertyExplicitlySet("isSecure")) {
                this.isSecure(model.getIsSecure());
            }
            if (model.wasPropertyExplicitlySet("isCloudSqlConfigured")) {
                this.isCloudSqlConfigured(model.getIsCloudSqlConfigured());
            }
            if (model.wasPropertyExplicitlySet("networkConfig")) {
                this.networkConfig(model.getNetworkConfig());
            }
            if (model.wasPropertyExplicitlySet("clusterDetails")) {
                this.clusterDetails(model.getClusterDetails());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("cloudSqlDetails")) {
                this.cloudSqlDetails(model.getCloudSqlDetails());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("numberOfNodes")) {
                this.numberOfNodes(model.getNumberOfNodes());
            }
            if (model.wasPropertyExplicitlySet("bootstrapScriptUrl")) {
                this.bootstrapScriptUrl(model.getBootstrapScriptUrl());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            return this;
        }
    }
}

