/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.MetricThresholdRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalePolicyMetricRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricType")
    private final MetricType metricType;
    @JsonProperty(value="threshold")
    private final MetricThresholdRule threshold;

    @Deprecated
    @ConstructorProperties(value={"metricType", "threshold"})
    public AutoScalePolicyMetricRule(MetricType metricType, MetricThresholdRule threshold) {
        this.metricType = metricType;
        this.threshold = threshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public MetricThresholdRule getThreshold() {
        return this.threshold;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalePolicyMetricRule(");
        sb.append("super=").append(super.toString());
        sb.append("metricType=").append(String.valueOf((Object)this.metricType));
        sb.append(", threshold=").append(String.valueOf((Object)this.threshold));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalePolicyMetricRule)) {
            return false;
        }
        AutoScalePolicyMetricRule other = (AutoScalePolicyMetricRule)((Object)o);
        return Objects.equals((Object)this.metricType, (Object)other.metricType) && Objects.equals((Object)this.threshold, (Object)other.threshold) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricType == null ? 43 : this.metricType.hashCode());
        result = result * 59 + (this.threshold == null ? 43 : this.threshold.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MetricType implements BmcEnum
    {
        CpuUtilization("CPU_UTILIZATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MetricType> map;

        private MetricType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MetricType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MetricType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MetricType.class);
            map = new HashMap<String, MetricType>();
            for (MetricType v : MetricType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricType")
        private MetricType metricType;
        @JsonProperty(value="threshold")
        private MetricThresholdRule threshold;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            this.__explicitlySet__.add("metricType");
            return this;
        }

        public Builder threshold(MetricThresholdRule threshold) {
            this.threshold = threshold;
            this.__explicitlySet__.add("threshold");
            return this;
        }

        public AutoScalePolicyMetricRule build() {
            AutoScalePolicyMetricRule model = new AutoScalePolicyMetricRule(this.metricType, this.threshold);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoScalePolicyMetricRule model) {
            if (model.wasPropertyExplicitlySet("metricType")) {
                this.metricType(model.getMetricType());
            }
            if (model.wasPropertyExplicitlySet("threshold")) {
                this.threshold(model.getThreshold());
            }
            return this;
        }
    }
}

