/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.bds.model.MetricBasedHorizontalScalingPolicyDetails;
import com.oracle.bmc.bds.model.MetricBasedVerticalScalingPolicyDetails;
import com.oracle.bmc.bds.model.ScheduleBasedHorizontalScalingPolicyDetails;
import com.oracle.bmc.bds.model.ScheduleBasedVerticalScalingPolicyDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="policyType", defaultImpl=AutoScalePolicyDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MetricBasedVerticalScalingPolicyDetails.class, name="METRIC_BASED_VERTICAL_SCALING_POLICY"), @JsonSubTypes.Type(value=ScheduleBasedVerticalScalingPolicyDetails.class, name="SCHEDULE_BASED_VERTICAL_SCALING_POLICY"), @JsonSubTypes.Type(value=ScheduleBasedHorizontalScalingPolicyDetails.class, name="SCHEDULE_BASED_HORIZONTAL_SCALING_POLICY"), @JsonSubTypes.Type(value=MetricBasedHorizontalScalingPolicyDetails.class, name="METRIC_BASED_HORIZONTAL_SCALING_POLICY")})
@JsonFilter(value="explicitlySetFilter")
public class AutoScalePolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="triggerType")
    private final TriggerType triggerType;
    @JsonProperty(value="actionType")
    private final ActionType actionType;

    @Deprecated
    @ConstructorProperties(value={"triggerType", "actionType"})
    protected AutoScalePolicyDetails(TriggerType triggerType, ActionType actionType) {
        this.triggerType = triggerType;
        this.actionType = actionType;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalePolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("triggerType=").append(String.valueOf((Object)this.triggerType));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalePolicyDetails)) {
            return false;
        }
        AutoScalePolicyDetails other = (AutoScalePolicyDetails)((Object)o);
        return Objects.equals((Object)this.triggerType, (Object)other.triggerType) && Objects.equals((Object)this.actionType, (Object)other.actionType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.triggerType == null ? 43 : this.triggerType.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PolicyType implements BmcEnum
    {
        MetricBasedVerticalScalingPolicy("METRIC_BASED_VERTICAL_SCALING_POLICY"),
        MetricBasedHorizontalScalingPolicy("METRIC_BASED_HORIZONTAL_SCALING_POLICY"),
        ScheduleBasedVerticalScalingPolicy("SCHEDULE_BASED_VERTICAL_SCALING_POLICY"),
        ScheduleBasedHorizontalScalingPolicy("SCHEDULE_BASED_HORIZONTAL_SCALING_POLICY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PolicyType> map;

        private PolicyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PolicyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PolicyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PolicyType.class);
            map = new HashMap<String, PolicyType>();
            for (PolicyType v : PolicyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ActionType implements BmcEnum
    {
        VerticalScaling("VERTICAL_SCALING"),
        HorizontalScaling("HORIZONTAL_SCALING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TriggerType implements BmcEnum
    {
        MetricBased("METRIC_BASED"),
        ScheduleBased("SCHEDULE_BASED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggerType> map;

        private TriggerType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggerType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggerType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggerType.class);
            map = new HashMap<String, TriggerType>();
            for (TriggerType v : TriggerType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

