/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bds.model.AutoScalePolicyRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalePolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="policyType")
    private final PolicyType policyType;
    @JsonProperty(value="rules")
    private final List<AutoScalePolicyRule> rules;

    @Deprecated
    @ConstructorProperties(value={"policyType", "rules"})
    public AutoScalePolicy(PolicyType policyType, List<AutoScalePolicyRule> rules) {
        this.policyType = policyType;
        this.rules = rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PolicyType getPolicyType() {
        return this.policyType;
    }

    public List<AutoScalePolicyRule> getRules() {
        return this.rules;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalePolicy(");
        sb.append("super=").append(super.toString());
        sb.append("policyType=").append(String.valueOf((Object)this.policyType));
        sb.append(", rules=").append(String.valueOf(this.rules));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalePolicy)) {
            return false;
        }
        AutoScalePolicy other = (AutoScalePolicy)((Object)o);
        return Objects.equals((Object)this.policyType, (Object)other.policyType) && Objects.equals(this.rules, other.rules) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.policyType == null ? 43 : this.policyType.hashCode());
        result = result * 59 + (this.rules == null ? 43 : this.rules.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PolicyType implements BmcEnum
    {
        ThresholdBased("THRESHOLD_BASED"),
        ScheduleBased("SCHEDULE_BASED"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PolicyType> map;

        private PolicyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PolicyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PolicyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PolicyType.class);
            map = new HashMap<String, PolicyType>();
            for (PolicyType v : PolicyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policyType")
        private PolicyType policyType;
        @JsonProperty(value="rules")
        private List<AutoScalePolicyRule> rules;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policyType(PolicyType policyType) {
            this.policyType = policyType;
            this.__explicitlySet__.add("policyType");
            return this;
        }

        public Builder rules(List<AutoScalePolicyRule> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public AutoScalePolicy build() {
            AutoScalePolicy model = new AutoScalePolicy(this.policyType, this.rules);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoScalePolicy model) {
            if (model.wasPropertyExplicitlySet("policyType")) {
                this.policyType(model.getPolicyType());
            }
            if (model.wasPropertyExplicitlySet("rules")) {
                this.rules(model.getRules());
            }
            return this;
        }
    }
}

