/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddBlockStorageDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clusterAdminPassword")
    private final String clusterAdminPassword;
    @JsonProperty(value="blockVolumeSizeInGBs")
    private final Long blockVolumeSizeInGBs;
    @JsonProperty(value="nodeType")
    private final NodeType nodeType;

    @Deprecated
    @ConstructorProperties(value={"clusterAdminPassword", "blockVolumeSizeInGBs", "nodeType"})
    public AddBlockStorageDetails(String clusterAdminPassword, Long blockVolumeSizeInGBs, NodeType nodeType) {
        this.clusterAdminPassword = clusterAdminPassword;
        this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
        this.nodeType = nodeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getClusterAdminPassword() {
        return this.clusterAdminPassword;
    }

    public Long getBlockVolumeSizeInGBs() {
        return this.blockVolumeSizeInGBs;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddBlockStorageDetails(");
        sb.append("super=").append(super.toString());
        sb.append("clusterAdminPassword=").append("<redacted>");
        sb.append(", blockVolumeSizeInGBs=").append(String.valueOf(this.blockVolumeSizeInGBs));
        sb.append(", nodeType=").append(String.valueOf((Object)this.nodeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddBlockStorageDetails)) {
            return false;
        }
        AddBlockStorageDetails other = (AddBlockStorageDetails)((Object)o);
        return Objects.equals(this.clusterAdminPassword, other.clusterAdminPassword) && Objects.equals(this.blockVolumeSizeInGBs, other.blockVolumeSizeInGBs) && Objects.equals((Object)this.nodeType, (Object)other.nodeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clusterAdminPassword == null ? 43 : this.clusterAdminPassword.hashCode());
        result = result * 59 + (this.blockVolumeSizeInGBs == null ? 43 : this.blockVolumeSizeInGBs.hashCode());
        result = result * 59 + (this.nodeType == null ? 43 : this.nodeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NodeType implements BmcEnum
    {
        Worker("WORKER"),
        ComputeOnlyWorker("COMPUTE_ONLY_WORKER");

        private final String value;
        private static Map<String, NodeType> map;

        private NodeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NodeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid NodeType: " + key);
        }

        static {
            map = new HashMap<String, NodeType>();
            for (NodeType v : NodeType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clusterAdminPassword")
        private String clusterAdminPassword;
        @JsonProperty(value="blockVolumeSizeInGBs")
        private Long blockVolumeSizeInGBs;
        @JsonProperty(value="nodeType")
        private NodeType nodeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clusterAdminPassword(String clusterAdminPassword) {
            this.clusterAdminPassword = clusterAdminPassword;
            this.__explicitlySet__.add("clusterAdminPassword");
            return this;
        }

        public Builder blockVolumeSizeInGBs(Long blockVolumeSizeInGBs) {
            this.blockVolumeSizeInGBs = blockVolumeSizeInGBs;
            this.__explicitlySet__.add("blockVolumeSizeInGBs");
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            this.__explicitlySet__.add("nodeType");
            return this;
        }

        public AddBlockStorageDetails build() {
            AddBlockStorageDetails model = new AddBlockStorageDetails(this.clusterAdminPassword, this.blockVolumeSizeInGBs, this.nodeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddBlockStorageDetails model) {
            if (model.wasPropertyExplicitlySet("clusterAdminPassword")) {
                this.clusterAdminPassword(model.getClusterAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("blockVolumeSizeInGBs")) {
                this.blockVolumeSizeInGBs(model.getBlockVolumeSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("nodeType")) {
                this.nodeType(model.getNodeType());
            }
            return this;
        }
    }
}

