/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bastion.model.PublicKeyDetails;
import com.oracle.bmc.bastion.model.SessionLifecycleState;
import com.oracle.bmc.bastion.model.TargetResourceDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Session
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="bastionId")
    private final String bastionId;
    @JsonProperty(value="bastionName")
    private final String bastionName;
    @JsonProperty(value="bastionUserName")
    private final String bastionUserName;
    @JsonProperty(value="targetResourceDetails")
    private final TargetResourceDetails targetResourceDetails;
    @JsonProperty(value="sshMetadata")
    private final Map<String, String> sshMetadata;
    @JsonProperty(value="keyType")
    private final KeyType keyType;
    @JsonProperty(value="keyDetails")
    private final PublicKeyDetails keyDetails;
    @JsonProperty(value="bastionPublicHostKeyInfo")
    private final String bastionPublicHostKeyInfo;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final SessionLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="sessionTtlInSeconds")
    private final Integer sessionTtlInSeconds;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "bastionId", "bastionName", "bastionUserName", "targetResourceDetails", "sshMetadata", "keyType", "keyDetails", "bastionPublicHostKeyInfo", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "sessionTtlInSeconds"})
    public Session(String id, String displayName, String bastionId, String bastionName, String bastionUserName, TargetResourceDetails targetResourceDetails, Map<String, String> sshMetadata, KeyType keyType, PublicKeyDetails keyDetails, String bastionPublicHostKeyInfo, Date timeCreated, Date timeUpdated, SessionLifecycleState lifecycleState, String lifecycleDetails, Integer sessionTtlInSeconds) {
        this.id = id;
        this.displayName = displayName;
        this.bastionId = bastionId;
        this.bastionName = bastionName;
        this.bastionUserName = bastionUserName;
        this.targetResourceDetails = targetResourceDetails;
        this.sshMetadata = sshMetadata;
        this.keyType = keyType;
        this.keyDetails = keyDetails;
        this.bastionPublicHostKeyInfo = bastionPublicHostKeyInfo;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.sessionTtlInSeconds = sessionTtlInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBastionId() {
        return this.bastionId;
    }

    public String getBastionName() {
        return this.bastionName;
    }

    public String getBastionUserName() {
        return this.bastionUserName;
    }

    public TargetResourceDetails getTargetResourceDetails() {
        return this.targetResourceDetails;
    }

    public Map<String, String> getSshMetadata() {
        return this.sshMetadata;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public PublicKeyDetails getKeyDetails() {
        return this.keyDetails;
    }

    public String getBastionPublicHostKeyInfo() {
        return this.bastionPublicHostKeyInfo;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public SessionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getSessionTtlInSeconds() {
        return this.sessionTtlInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Session(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", bastionId=").append(String.valueOf(this.bastionId));
        sb.append(", bastionName=").append(String.valueOf(this.bastionName));
        sb.append(", bastionUserName=").append(String.valueOf(this.bastionUserName));
        sb.append(", targetResourceDetails=").append(String.valueOf((Object)this.targetResourceDetails));
        sb.append(", sshMetadata=").append(String.valueOf(this.sshMetadata));
        sb.append(", keyType=").append(String.valueOf((Object)this.keyType));
        sb.append(", keyDetails=").append(String.valueOf((Object)this.keyDetails));
        sb.append(", bastionPublicHostKeyInfo=").append(String.valueOf(this.bastionPublicHostKeyInfo));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", sessionTtlInSeconds=").append(String.valueOf(this.sessionTtlInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.bastionId, other.bastionId) && Objects.equals(this.bastionName, other.bastionName) && Objects.equals(this.bastionUserName, other.bastionUserName) && Objects.equals((Object)this.targetResourceDetails, (Object)other.targetResourceDetails) && Objects.equals(this.sshMetadata, other.sshMetadata) && Objects.equals((Object)this.keyType, (Object)other.keyType) && Objects.equals((Object)this.keyDetails, (Object)other.keyDetails) && Objects.equals(this.bastionPublicHostKeyInfo, other.bastionPublicHostKeyInfo) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.sessionTtlInSeconds, other.sessionTtlInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.bastionId == null ? 43 : this.bastionId.hashCode());
        result = result * 59 + (this.bastionName == null ? 43 : this.bastionName.hashCode());
        result = result * 59 + (this.bastionUserName == null ? 43 : this.bastionUserName.hashCode());
        result = result * 59 + (this.targetResourceDetails == null ? 43 : this.targetResourceDetails.hashCode());
        result = result * 59 + (this.sshMetadata == null ? 43 : this.sshMetadata.hashCode());
        result = result * 59 + (this.keyType == null ? 43 : this.keyType.hashCode());
        result = result * 59 + (this.keyDetails == null ? 43 : this.keyDetails.hashCode());
        result = result * 59 + (this.bastionPublicHostKeyInfo == null ? 43 : this.bastionPublicHostKeyInfo.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.sessionTtlInSeconds == null ? 43 : this.sessionTtlInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum KeyType implements BmcEnum
    {
        Pub("PUB"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyType> map;

        private KeyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyType.class);
            map = new HashMap<String, KeyType>();
            for (KeyType v : KeyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="bastionId")
        private String bastionId;
        @JsonProperty(value="bastionName")
        private String bastionName;
        @JsonProperty(value="bastionUserName")
        private String bastionUserName;
        @JsonProperty(value="targetResourceDetails")
        private TargetResourceDetails targetResourceDetails;
        @JsonProperty(value="sshMetadata")
        private Map<String, String> sshMetadata;
        @JsonProperty(value="keyType")
        private KeyType keyType;
        @JsonProperty(value="keyDetails")
        private PublicKeyDetails keyDetails;
        @JsonProperty(value="bastionPublicHostKeyInfo")
        private String bastionPublicHostKeyInfo;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private SessionLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="sessionTtlInSeconds")
        private Integer sessionTtlInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder bastionId(String bastionId) {
            this.bastionId = bastionId;
            this.__explicitlySet__.add("bastionId");
            return this;
        }

        public Builder bastionName(String bastionName) {
            this.bastionName = bastionName;
            this.__explicitlySet__.add("bastionName");
            return this;
        }

        public Builder bastionUserName(String bastionUserName) {
            this.bastionUserName = bastionUserName;
            this.__explicitlySet__.add("bastionUserName");
            return this;
        }

        public Builder targetResourceDetails(TargetResourceDetails targetResourceDetails) {
            this.targetResourceDetails = targetResourceDetails;
            this.__explicitlySet__.add("targetResourceDetails");
            return this;
        }

        public Builder sshMetadata(Map<String, String> sshMetadata) {
            this.sshMetadata = sshMetadata;
            this.__explicitlySet__.add("sshMetadata");
            return this;
        }

        public Builder keyType(KeyType keyType) {
            this.keyType = keyType;
            this.__explicitlySet__.add("keyType");
            return this;
        }

        public Builder keyDetails(PublicKeyDetails keyDetails) {
            this.keyDetails = keyDetails;
            this.__explicitlySet__.add("keyDetails");
            return this;
        }

        public Builder bastionPublicHostKeyInfo(String bastionPublicHostKeyInfo) {
            this.bastionPublicHostKeyInfo = bastionPublicHostKeyInfo;
            this.__explicitlySet__.add("bastionPublicHostKeyInfo");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(SessionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder sessionTtlInSeconds(Integer sessionTtlInSeconds) {
            this.sessionTtlInSeconds = sessionTtlInSeconds;
            this.__explicitlySet__.add("sessionTtlInSeconds");
            return this;
        }

        public Session build() {
            Session model = new Session(this.id, this.displayName, this.bastionId, this.bastionName, this.bastionUserName, this.targetResourceDetails, this.sshMetadata, this.keyType, this.keyDetails, this.bastionPublicHostKeyInfo, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.sessionTtlInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Session model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("bastionId")) {
                this.bastionId(model.getBastionId());
            }
            if (model.wasPropertyExplicitlySet("bastionName")) {
                this.bastionName(model.getBastionName());
            }
            if (model.wasPropertyExplicitlySet("bastionUserName")) {
                this.bastionUserName(model.getBastionUserName());
            }
            if (model.wasPropertyExplicitlySet("targetResourceDetails")) {
                this.targetResourceDetails(model.getTargetResourceDetails());
            }
            if (model.wasPropertyExplicitlySet("sshMetadata")) {
                this.sshMetadata(model.getSshMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyType")) {
                this.keyType(model.getKeyType());
            }
            if (model.wasPropertyExplicitlySet("keyDetails")) {
                this.keyDetails(model.getKeyDetails());
            }
            if (model.wasPropertyExplicitlySet("bastionPublicHostKeyInfo")) {
                this.bastionPublicHostKeyInfo(model.getBastionPublicHostKeyInfo());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("sessionTtlInSeconds")) {
                this.sessionTtlInSeconds(model.getSessionTtlInSeconds());
            }
            return this;
        }
    }
}

