/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import com.oracle.bmc.autoscaling.model.Capacity;
import com.oracle.bmc.autoscaling.model.ExecutionSchedule;
import com.oracle.bmc.autoscaling.model.ResourceAction;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="policyType")
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledPolicy
extends AutoScalingPolicy {
    @JsonProperty(value="executionSchedule")
    private final ExecutionSchedule executionSchedule;
    @JsonProperty(value="resourceAction")
    private final ResourceAction resourceAction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScheduledPolicy(Capacity capacity, String id, String displayName, Date timeCreated, Boolean isEnabled, ExecutionSchedule executionSchedule, ResourceAction resourceAction) {
        super(capacity, id, displayName, timeCreated, isEnabled);
        this.executionSchedule = executionSchedule;
        this.resourceAction = resourceAction;
    }

    public ExecutionSchedule getExecutionSchedule() {
        return this.executionSchedule;
    }

    public ResourceAction getResourceAction() {
        return this.resourceAction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", executionSchedule=").append(String.valueOf((Object)this.executionSchedule));
        sb.append(", resourceAction=").append(String.valueOf((Object)this.resourceAction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledPolicy)) {
            return false;
        }
        ScheduledPolicy other = (ScheduledPolicy)((Object)o);
        return Objects.equals((Object)this.executionSchedule, (Object)other.executionSchedule) && Objects.equals((Object)this.resourceAction, (Object)other.resourceAction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.executionSchedule == null ? 43 : this.executionSchedule.hashCode());
        result = result * 59 + (this.resourceAction == null ? 43 : this.resourceAction.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="capacity")
        private Capacity capacity;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="executionSchedule")
        private ExecutionSchedule executionSchedule;
        @JsonProperty(value="resourceAction")
        private ResourceAction resourceAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder executionSchedule(ExecutionSchedule executionSchedule) {
            this.executionSchedule = executionSchedule;
            this.__explicitlySet__.add("executionSchedule");
            return this;
        }

        public Builder resourceAction(ResourceAction resourceAction) {
            this.resourceAction = resourceAction;
            this.__explicitlySet__.add("resourceAction");
            return this;
        }

        public ScheduledPolicy build() {
            ScheduledPolicy model = new ScheduledPolicy(this.capacity, this.id, this.displayName, this.timeCreated, this.isEnabled, this.executionSchedule, this.resourceAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledPolicy model) {
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("executionSchedule")) {
                this.executionSchedule(model.getExecutionSchedule());
            }
            if (model.wasPropertyExplicitlySet("resourceAction")) {
                this.resourceAction(model.getResourceAction());
            }
            return this;
        }
    }
}

