/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.autoscaling.model.Capacity;
import com.oracle.bmc.autoscaling.model.CreateAutoScalingPolicyDetails;
import com.oracle.bmc.autoscaling.model.CreateConditionDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="policyType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateThresholdPolicyDetails
extends CreateAutoScalingPolicyDetails {
    @JsonProperty(value="rules")
    private final List<CreateConditionDetails> rules;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateThresholdPolicyDetails(Capacity capacity, String displayName, Boolean isEnabled, List<CreateConditionDetails> rules) {
        super(capacity, displayName, isEnabled);
        this.rules = rules;
    }

    public List<CreateConditionDetails> getRules() {
        return this.rules;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateThresholdPolicyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", rules=").append(String.valueOf(this.rules));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateThresholdPolicyDetails)) {
            return false;
        }
        CreateThresholdPolicyDetails other = (CreateThresholdPolicyDetails)((Object)o);
        return Objects.equals(this.rules, other.rules) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rules == null ? 43 : this.rules.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="capacity")
        private Capacity capacity;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="rules")
        private List<CreateConditionDetails> rules;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder rules(List<CreateConditionDetails> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public CreateThresholdPolicyDetails build() {
            CreateThresholdPolicyDetails model = new CreateThresholdPolicyDetails(this.capacity, this.displayName, this.isEnabled, this.rules);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateThresholdPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("rules")) {
                this.rules(model.getRules());
            }
            return this;
        }
    }
}

