/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.autoscaling.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.autoscaling.model.AutoScalingPolicy;
import com.oracle.bmc.autoscaling.model.Resource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalingConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="coolDownInSeconds")
    private final Integer coolDownInSeconds;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="resource")
    private final Resource resource;
    @JsonProperty(value="policies")
    private final List<AutoScalingPolicy> policies;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="maxResourceCount")
    private final Integer maxResourceCount;
    @JsonProperty(value="minResourceCount")
    private final Integer minResourceCount;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "freeformTags", "id", "coolDownInSeconds", "isEnabled", "resource", "policies", "timeCreated", "maxResourceCount", "minResourceCount"})
    public AutoScalingConfiguration(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, Integer coolDownInSeconds, Boolean isEnabled, Resource resource, List<AutoScalingPolicy> policies, Date timeCreated, Integer maxResourceCount, Integer minResourceCount) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.coolDownInSeconds = coolDownInSeconds;
        this.isEnabled = isEnabled;
        this.resource = resource;
        this.policies = policies;
        this.timeCreated = timeCreated;
        this.maxResourceCount = maxResourceCount;
        this.minResourceCount = minResourceCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public Integer getCoolDownInSeconds() {
        return this.coolDownInSeconds;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<AutoScalingPolicy> getPolicies() {
        return this.policies;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getMaxResourceCount() {
        return this.maxResourceCount;
    }

    public Integer getMinResourceCount() {
        return this.minResourceCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalingConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", coolDownInSeconds=").append(String.valueOf(this.coolDownInSeconds));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", resource=").append(String.valueOf((Object)this.resource));
        sb.append(", policies=").append(String.valueOf(this.policies));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", maxResourceCount=").append(String.valueOf(this.maxResourceCount));
        sb.append(", minResourceCount=").append(String.valueOf(this.minResourceCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalingConfiguration)) {
            return false;
        }
        AutoScalingConfiguration other = (AutoScalingConfiguration)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.coolDownInSeconds, other.coolDownInSeconds) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.resource, (Object)other.resource) && Objects.equals(this.policies, other.policies) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.maxResourceCount, other.maxResourceCount) && Objects.equals(this.minResourceCount, other.minResourceCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.coolDownInSeconds == null ? 43 : this.coolDownInSeconds.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.resource == null ? 43 : this.resource.hashCode());
        result = result * 59 + (this.policies == null ? 43 : this.policies.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.maxResourceCount == null ? 43 : this.maxResourceCount.hashCode());
        result = result * 59 + (this.minResourceCount == null ? 43 : this.minResourceCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="coolDownInSeconds")
        private Integer coolDownInSeconds;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="resource")
        private Resource resource;
        @JsonProperty(value="policies")
        private List<AutoScalingPolicy> policies;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="maxResourceCount")
        private Integer maxResourceCount;
        @JsonProperty(value="minResourceCount")
        private Integer minResourceCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder coolDownInSeconds(Integer coolDownInSeconds) {
            this.coolDownInSeconds = coolDownInSeconds;
            this.__explicitlySet__.add("coolDownInSeconds");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            this.__explicitlySet__.add("resource");
            return this;
        }

        public Builder policies(List<AutoScalingPolicy> policies) {
            this.policies = policies;
            this.__explicitlySet__.add("policies");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder maxResourceCount(Integer maxResourceCount) {
            this.maxResourceCount = maxResourceCount;
            this.__explicitlySet__.add("maxResourceCount");
            return this;
        }

        public Builder minResourceCount(Integer minResourceCount) {
            this.minResourceCount = minResourceCount;
            this.__explicitlySet__.add("minResourceCount");
            return this;
        }

        public AutoScalingConfiguration build() {
            AutoScalingConfiguration model = new AutoScalingConfiguration(this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.id, this.coolDownInSeconds, this.isEnabled, this.resource, this.policies, this.timeCreated, this.maxResourceCount, this.minResourceCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoScalingConfiguration model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("coolDownInSeconds")) {
                this.coolDownInSeconds(model.getCoolDownInSeconds());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("resource")) {
                this.resource(model.getResource());
            }
            if (model.wasPropertyExplicitlySet("policies")) {
                this.policies(model.getPolicies());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("maxResourceCount")) {
                this.maxResourceCount(model.getMaxResourceCount());
            }
            if (model.wasPropertyExplicitlySet("minResourceCount")) {
                this.minResourceCount(model.getMinResourceCount());
            }
            return this;
        }
    }
}

