/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.audit.model.UpdateConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateConfigurationRequest
extends BmcRequest<UpdateConfigurationDetails> {
    private String compartmentId;
    private UpdateConfigurationDetails updateConfigurationDetails;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateConfigurationDetails getUpdateConfigurationDetails() {
        return this.updateConfigurationDetails;
    }

    @InternalSdk
    public UpdateConfigurationDetails getBody$() {
        return this.updateConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).updateConfigurationDetails(this.updateConfigurationDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateConfigurationDetails=").append(String.valueOf((Object)this.updateConfigurationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConfigurationRequest)) {
            return false;
        }
        UpdateConfigurationRequest other = (UpdateConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateConfigurationDetails, (Object)other.updateConfigurationDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateConfigurationDetails == null ? 43 : this.updateConfigurationDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConfigurationRequest, UpdateConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private UpdateConfigurationDetails updateConfigurationDetails = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateConfigurationDetails(UpdateConfigurationDetails updateConfigurationDetails) {
            this.updateConfigurationDetails = updateConfigurationDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConfigurationRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateConfigurationDetails(o.getUpdateConfigurationDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConfigurationRequest build() {
            UpdateConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConfigurationDetails body) {
            this.updateConfigurationDetails(body);
            return this;
        }

        public UpdateConfigurationRequest buildWithoutInvocationCallback() {
            UpdateConfigurationRequest request = new UpdateConfigurationRequest();
            request.compartmentId = this.compartmentId;
            request.updateConfigurationDetails = this.updateConfigurationDetails;
            return request;
        }
    }
}

