/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConfigurationRequest
extends BmcRequest<Void> {
    private String compartmentId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConfigurationRequest)) {
            return false;
        }
        GetConfigurationRequest other = (GetConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConfigurationRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConfigurationRequest build() {
            GetConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConfigurationRequest buildWithoutInvocationCallback() {
            GetConfigurationRequest request = new GetConfigurationRequest();
            request.compartmentId = this.compartmentId;
            return request;
        }
    }
}

