/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Request
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="parameters")
    private final Map<String, List<String>> parameters;
    @JsonProperty(value="headers")
    private final Map<String, List<String>> headers;

    @Deprecated
    @ConstructorProperties(value={"id", "path", "action", "parameters", "headers"})
    public Request(String id, String path, String action, Map<String, List<String>> parameters, Map<String, List<String>> headers) {
        this.id = id;
        this.path = path;
        this.action = action;
        this.parameters = parameters;
        this.headers = headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getAction() {
        return this.action;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Request(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.action, other.action) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.headers, other.headers) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="parameters")
        private Map<String, List<String>> parameters;
        @JsonProperty(value="headers")
        private Map<String, List<String>> headers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder parameters(Map<String, List<String>> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Request build() {
            Request model = new Request(this.id, this.path, this.action, this.parameters, this.headers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Request model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            return this;
        }
    }
}

