/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Identity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="principalName")
    private final String principalName;
    @JsonProperty(value="principalId")
    private final String principalId;
    @JsonProperty(value="authType")
    private final String authType;
    @JsonProperty(value="callerName")
    private final String callerName;
    @JsonProperty(value="callerId")
    private final String callerId;
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="credentials")
    private final String credentials;
    @JsonProperty(value="userAgent")
    private final String userAgent;
    @JsonProperty(value="consoleSessionId")
    private final String consoleSessionId;

    @Deprecated
    @ConstructorProperties(value={"principalName", "principalId", "authType", "callerName", "callerId", "tenantId", "ipAddress", "credentials", "userAgent", "consoleSessionId"})
    public Identity(String principalName, String principalId, String authType, String callerName, String callerId, String tenantId, String ipAddress, String credentials, String userAgent, String consoleSessionId) {
        this.principalName = principalName;
        this.principalId = principalId;
        this.authType = authType;
        this.callerName = callerName;
        this.callerId = callerId;
        this.tenantId = tenantId;
        this.ipAddress = ipAddress;
        this.credentials = credentials;
        this.userAgent = userAgent;
        this.consoleSessionId = consoleSessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getConsoleSessionId() {
        return this.consoleSessionId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Identity(");
        sb.append("super=").append(super.toString());
        sb.append("principalName=").append(String.valueOf(this.principalName));
        sb.append(", principalId=").append(String.valueOf(this.principalId));
        sb.append(", authType=").append(String.valueOf(this.authType));
        sb.append(", callerName=").append(String.valueOf(this.callerName));
        sb.append(", callerId=").append(String.valueOf(this.callerId));
        sb.append(", tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", credentials=").append(String.valueOf(this.credentials));
        sb.append(", userAgent=").append(String.valueOf(this.userAgent));
        sb.append(", consoleSessionId=").append(String.valueOf(this.consoleSessionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)((Object)o);
        return Objects.equals(this.principalName, other.principalName) && Objects.equals(this.principalId, other.principalId) && Objects.equals(this.authType, other.authType) && Objects.equals(this.callerName, other.callerName) && Objects.equals(this.callerId, other.callerId) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.credentials, other.credentials) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.consoleSessionId, other.consoleSessionId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.principalName == null ? 43 : this.principalName.hashCode());
        result = result * 59 + (this.principalId == null ? 43 : this.principalId.hashCode());
        result = result * 59 + (this.authType == null ? 43 : this.authType.hashCode());
        result = result * 59 + (this.callerName == null ? 43 : this.callerName.hashCode());
        result = result * 59 + (this.callerId == null ? 43 : this.callerId.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.userAgent == null ? 43 : this.userAgent.hashCode());
        result = result * 59 + (this.consoleSessionId == null ? 43 : this.consoleSessionId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="principalName")
        private String principalName;
        @JsonProperty(value="principalId")
        private String principalId;
        @JsonProperty(value="authType")
        private String authType;
        @JsonProperty(value="callerName")
        private String callerName;
        @JsonProperty(value="callerId")
        private String callerId;
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="credentials")
        private String credentials;
        @JsonProperty(value="userAgent")
        private String userAgent;
        @JsonProperty(value="consoleSessionId")
        private String consoleSessionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder principalName(String principalName) {
            this.principalName = principalName;
            this.__explicitlySet__.add("principalName");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.__explicitlySet__.add("principalId");
            return this;
        }

        public Builder authType(String authType) {
            this.authType = authType;
            this.__explicitlySet__.add("authType");
            return this;
        }

        public Builder callerName(String callerName) {
            this.callerName = callerName;
            this.__explicitlySet__.add("callerName");
            return this;
        }

        public Builder callerId(String callerId) {
            this.callerId = callerId;
            this.__explicitlySet__.add("callerId");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.__explicitlySet__.add("userAgent");
            return this;
        }

        public Builder consoleSessionId(String consoleSessionId) {
            this.consoleSessionId = consoleSessionId;
            this.__explicitlySet__.add("consoleSessionId");
            return this;
        }

        public Identity build() {
            Identity model = new Identity(this.principalName, this.principalId, this.authType, this.callerName, this.callerId, this.tenantId, this.ipAddress, this.credentials, this.userAgent, this.consoleSessionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Identity model) {
            if (model.wasPropertyExplicitlySet("principalName")) {
                this.principalName(model.getPrincipalName());
            }
            if (model.wasPropertyExplicitlySet("principalId")) {
                this.principalId(model.getPrincipalId());
            }
            if (model.wasPropertyExplicitlySet("authType")) {
                this.authType(model.getAuthType());
            }
            if (model.wasPropertyExplicitlySet("callerName")) {
                this.callerName(model.getCallerName());
            }
            if (model.wasPropertyExplicitlySet("callerId")) {
                this.callerId(model.getCallerId());
            }
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("userAgent")) {
                this.userAgent(model.getUserAgent());
            }
            if (model.wasPropertyExplicitlySet("consoleSessionId")) {
                this.consoleSessionId(model.getConsoleSessionId());
            }
            return this;
        }
    }
}

