/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit;

import com.oracle.bmc.audit.Audit;
import com.oracle.bmc.audit.model.AuditEvent;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AuditPaginators {
    private final Audit client;

    public AuditPaginators(Audit client) {
        this.client = client;
    }

    public Iterable<ListEventsResponse> listEventsResponseIterator(final ListEventsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            @Override
            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            @Override
            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            @Override
            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            @Override
            public ListEventsResponse apply(ListEventsRequest request) {
                return AuditPaginators.this.client.listEvents(request);
            }
        });
    }

    public Iterable<AuditEvent> listEventsRecordIterator(final ListEventsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEventsRequest.Builder>(){

            @Override
            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEventsResponse, String>(){

            @Override
            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            @Override
            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEventsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEventsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEventsRequest, ListEventsResponse>(){

            @Override
            public ListEventsResponse apply(ListEventsRequest request) {
                return AuditPaginators.this.client.listEvents(request);
            }
        }, (Function)new Function<ListEventsResponse, List<AuditEvent>>(){

            @Override
            public List<AuditEvent> apply(ListEventsResponse response) {
                return response.getItems();
            }
        });
    }
}

