/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.applicationmigration;

import com.oracle.bmc.applicationmigration.ApplicationMigration;
import com.oracle.bmc.applicationmigration.model.MigrationSummary;
import com.oracle.bmc.applicationmigration.model.SourceApplicationSummary;
import com.oracle.bmc.applicationmigration.model.SourceSummary;
import com.oracle.bmc.applicationmigration.model.WorkRequestError;
import com.oracle.bmc.applicationmigration.model.WorkRequestLogEntry;
import com.oracle.bmc.applicationmigration.model.WorkRequestSummary;
import com.oracle.bmc.applicationmigration.requests.ListMigrationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourceApplicationsRequest;
import com.oracle.bmc.applicationmigration.requests.ListSourcesRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.applicationmigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.applicationmigration.responses.ListMigrationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourceApplicationsResponse;
import com.oracle.bmc.applicationmigration.responses.ListSourcesResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.applicationmigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ApplicationMigrationPaginators {
    private final ApplicationMigration client;

    public ApplicationMigrationPaginators(ApplicationMigration client) {
        this.client = client;
    }

    public Iterable<ListMigrationsResponse> listMigrationsResponseIterator(final ListMigrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listMigrations(request);
            }
        });
    }

    public Iterable<MigrationSummary> listMigrationsRecordIterator(final ListMigrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listMigrations(request);
            }
        }, (Function)new Function<ListMigrationsResponse, List<MigrationSummary>>(){

            @Override
            public List<MigrationSummary> apply(ListMigrationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSourceApplicationsResponse> listSourceApplicationsResponseIterator(final ListSourceApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSourceApplicationsRequest.Builder>(){

            @Override
            public ListSourceApplicationsRequest.Builder get() {
                return ListSourceApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, String>(){

            @Override
            public String apply(ListSourceApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourceApplicationsRequest.Builder>, ListSourceApplicationsRequest>(){

            @Override
            public ListSourceApplicationsRequest apply(RequestBuilderAndToken<ListSourceApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSourceApplicationsRequest, ListSourceApplicationsResponse>(){

            @Override
            public ListSourceApplicationsResponse apply(ListSourceApplicationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listSourceApplications(request);
            }
        });
    }

    public Iterable<SourceApplicationSummary> listSourceApplicationsRecordIterator(final ListSourceApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSourceApplicationsRequest.Builder>(){

            @Override
            public ListSourceApplicationsRequest.Builder get() {
                return ListSourceApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, String>(){

            @Override
            public String apply(ListSourceApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourceApplicationsRequest.Builder>, ListSourceApplicationsRequest>(){

            @Override
            public ListSourceApplicationsRequest apply(RequestBuilderAndToken<ListSourceApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourceApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSourceApplicationsRequest, ListSourceApplicationsResponse>(){

            @Override
            public ListSourceApplicationsResponse apply(ListSourceApplicationsRequest request) {
                return ApplicationMigrationPaginators.this.client.listSourceApplications(request);
            }
        }, (Function)new Function<ListSourceApplicationsResponse, List<SourceApplicationSummary>>(){

            @Override
            public List<SourceApplicationSummary> apply(ListSourceApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSourcesResponse> listSourcesResponseIterator(final ListSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSourcesRequest.Builder>(){

            @Override
            public ListSourcesRequest.Builder get() {
                return ListSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourcesResponse, String>(){

            @Override
            public String apply(ListSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourcesRequest.Builder>, ListSourcesRequest>(){

            @Override
            public ListSourcesRequest apply(RequestBuilderAndToken<ListSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSourcesRequest, ListSourcesResponse>(){

            @Override
            public ListSourcesResponse apply(ListSourcesRequest request) {
                return ApplicationMigrationPaginators.this.client.listSources(request);
            }
        });
    }

    public Iterable<SourceSummary> listSourcesRecordIterator(final ListSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSourcesRequest.Builder>(){

            @Override
            public ListSourcesRequest.Builder get() {
                return ListSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSourcesResponse, String>(){

            @Override
            public String apply(ListSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSourcesRequest.Builder>, ListSourcesRequest>(){

            @Override
            public ListSourcesRequest apply(RequestBuilderAndToken<ListSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSourcesRequest, ListSourcesResponse>(){

            @Override
            public ListSourcesResponse apply(ListSourcesRequest request) {
                return ApplicationMigrationPaginators.this.client.listSources(request);
            }
        }, (Function)new Function<ListSourcesResponse, List<SourceSummary>>(){

            @Override
            public List<SourceSummary> apply(ListSourcesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ApplicationMigrationPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

