/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.responses;

import com.oracle.bmc.apmtraces.model.QuickPickSummary;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListQuickPicksResponse
extends BmcResponse {
    private String opcRequestId;
    private Integer opcTotalItems;
    private String opcNextPage;
    private List<QuickPickSummary> items;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<QuickPickSummary> getItems() {
        return this.items;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcTotalItems", "opcNextPage", "items"})
    private ListQuickPicksResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, Integer opcTotalItems, String opcNextPage, List<QuickPickSummary> items) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcTotalItems = opcTotalItems;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListQuickPicksResponse)) {
            return false;
        }
        ListQuickPicksResponse other = (ListQuickPicksResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.items, other.items);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListQuickPicksResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private Integer opcTotalItems;
        private String opcNextPage;
        private List<QuickPickSummary> items;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<QuickPickSummary> items) {
            this.items = items;
            return this;
        }

        public Builder copy(ListQuickPicksResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        public ListQuickPicksResponse build() {
            return new ListQuickPicksResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcTotalItems, this.opcNextPage, this.items);
        }
    }
}

