/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmtraces.model.SnapshotDetail;
import com.oracle.bmc.apmtraces.model.SpanSnapshot;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TraceSnapshot
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="traceSnapshotDetails")
    private final List<SnapshotDetail> traceSnapshotDetails;
    @JsonProperty(value="spanSnapshots")
    private final List<SpanSnapshot> spanSnapshots;

    @Deprecated
    @ConstructorProperties(value={"key", "timeStarted", "timeEnded", "traceSnapshotDetails", "spanSnapshots"})
    public TraceSnapshot(String key, Date timeStarted, Date timeEnded, List<SnapshotDetail> traceSnapshotDetails, List<SpanSnapshot> spanSnapshots) {
        this.key = key;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.traceSnapshotDetails = traceSnapshotDetails;
        this.spanSnapshots = spanSnapshots;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public List<SnapshotDetail> getTraceSnapshotDetails() {
        return this.traceSnapshotDetails;
    }

    public List<SpanSnapshot> getSpanSnapshots() {
        return this.spanSnapshots;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TraceSnapshot(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", traceSnapshotDetails=").append(String.valueOf(this.traceSnapshotDetails));
        sb.append(", spanSnapshots=").append(String.valueOf(this.spanSnapshots));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TraceSnapshot)) {
            return false;
        }
        TraceSnapshot other = (TraceSnapshot)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.traceSnapshotDetails, other.traceSnapshotDetails) && Objects.equals(this.spanSnapshots, other.spanSnapshots) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.traceSnapshotDetails == null ? 43 : this.traceSnapshotDetails.hashCode());
        result = result * 59 + (this.spanSnapshots == null ? 43 : this.spanSnapshots.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="traceSnapshotDetails")
        private List<SnapshotDetail> traceSnapshotDetails;
        @JsonProperty(value="spanSnapshots")
        private List<SpanSnapshot> spanSnapshots;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder traceSnapshotDetails(List<SnapshotDetail> traceSnapshotDetails) {
            this.traceSnapshotDetails = traceSnapshotDetails;
            this.__explicitlySet__.add("traceSnapshotDetails");
            return this;
        }

        public Builder spanSnapshots(List<SpanSnapshot> spanSnapshots) {
            this.spanSnapshots = spanSnapshots;
            this.__explicitlySet__.add("spanSnapshots");
            return this;
        }

        public TraceSnapshot build() {
            TraceSnapshot model = new TraceSnapshot(this.key, this.timeStarted, this.timeEnded, this.traceSnapshotDetails, this.spanSnapshots);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TraceSnapshot model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("traceSnapshotDetails")) {
                this.traceSnapshotDetails(model.getTraceSnapshotDetails());
            }
            if (model.wasPropertyExplicitlySet("spanSnapshots")) {
                this.spanSnapshots(model.getSpanSnapshots());
            }
            return this;
        }
    }
}

