/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmtraces.model.SnapshotDetail;
import com.oracle.bmc.apmtraces.model.ThreadSnapshot;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SpanSnapshot
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="spanName")
    private final String spanName;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="spanSnapshotDetails")
    private final List<SnapshotDetail> spanSnapshotDetails;
    @JsonProperty(value="threadSnapshots")
    private final List<ThreadSnapshot> threadSnapshots;
    @JsonProperty(value="children")
    private final List<SpanSnapshot> children;

    @Deprecated
    @ConstructorProperties(value={"key", "spanName", "timeStarted", "timeEnded", "spanSnapshotDetails", "threadSnapshots", "children"})
    public SpanSnapshot(String key, String spanName, Date timeStarted, Date timeEnded, List<SnapshotDetail> spanSnapshotDetails, List<ThreadSnapshot> threadSnapshots, List<SpanSnapshot> children) {
        this.key = key;
        this.spanName = spanName;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.spanSnapshotDetails = spanSnapshotDetails;
        this.threadSnapshots = threadSnapshots;
        this.children = children;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public List<SnapshotDetail> getSpanSnapshotDetails() {
        return this.spanSnapshotDetails;
    }

    public List<ThreadSnapshot> getThreadSnapshots() {
        return this.threadSnapshots;
    }

    public List<SpanSnapshot> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SpanSnapshot(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", spanName=").append(String.valueOf(this.spanName));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", spanSnapshotDetails=").append(String.valueOf(this.spanSnapshotDetails));
        sb.append(", threadSnapshots=").append(String.valueOf(this.threadSnapshots));
        sb.append(", children=").append(String.valueOf(this.children));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanSnapshot)) {
            return false;
        }
        SpanSnapshot other = (SpanSnapshot)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.spanName, other.spanName) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.spanSnapshotDetails, other.spanSnapshotDetails) && Objects.equals(this.threadSnapshots, other.threadSnapshots) && Objects.equals(this.children, other.children) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.spanName == null ? 43 : this.spanName.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.spanSnapshotDetails == null ? 43 : this.spanSnapshotDetails.hashCode());
        result = result * 59 + (this.threadSnapshots == null ? 43 : this.threadSnapshots.hashCode());
        result = result * 59 + (this.children == null ? 43 : this.children.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="spanName")
        private String spanName;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="spanSnapshotDetails")
        private List<SnapshotDetail> spanSnapshotDetails;
        @JsonProperty(value="threadSnapshots")
        private List<ThreadSnapshot> threadSnapshots;
        @JsonProperty(value="children")
        private List<SpanSnapshot> children;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder spanName(String spanName) {
            this.spanName = spanName;
            this.__explicitlySet__.add("spanName");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder spanSnapshotDetails(List<SnapshotDetail> spanSnapshotDetails) {
            this.spanSnapshotDetails = spanSnapshotDetails;
            this.__explicitlySet__.add("spanSnapshotDetails");
            return this;
        }

        public Builder threadSnapshots(List<ThreadSnapshot> threadSnapshots) {
            this.threadSnapshots = threadSnapshots;
            this.__explicitlySet__.add("threadSnapshots");
            return this;
        }

        public Builder children(List<SpanSnapshot> children) {
            this.children = children;
            this.__explicitlySet__.add("children");
            return this;
        }

        public SpanSnapshot build() {
            SpanSnapshot model = new SpanSnapshot(this.key, this.spanName, this.timeStarted, this.timeEnded, this.spanSnapshotDetails, this.threadSnapshots, this.children);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SpanSnapshot model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("spanName")) {
                this.spanName(model.getSpanName());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("spanSnapshotDetails")) {
                this.spanSnapshotDetails(model.getSpanSnapshotDetails());
            }
            if (model.wasPropertyExplicitlySet("threadSnapshots")) {
                this.threadSnapshots(model.getThreadSnapshots());
            }
            if (model.wasPropertyExplicitlySet("children")) {
                this.children(model.getChildren());
            }
            return this;
        }
    }
}

