/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.oracle.bmc.apmtraces.Query;
import com.oracle.bmc.apmtraces.model.QuickPickSummary;
import com.oracle.bmc.apmtraces.requests.ListQuickPicksRequest;
import com.oracle.bmc.apmtraces.responses.ListQuickPicksResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class QueryPaginators {
    private final Query client;

    public QueryPaginators(Query client) {
        this.client = client;
    }

    public Iterable<ListQuickPicksResponse> listQuickPicksResponseIterator(final ListQuickPicksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListQuickPicksRequest.Builder>(){

            @Override
            public ListQuickPicksRequest.Builder get() {
                return ListQuickPicksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, String>(){

            @Override
            public String apply(ListQuickPicksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuickPicksRequest.Builder>, ListQuickPicksRequest>(){

            @Override
            public ListQuickPicksRequest apply(RequestBuilderAndToken<ListQuickPicksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQuickPicksRequest, ListQuickPicksResponse>(){

            @Override
            public ListQuickPicksResponse apply(ListQuickPicksRequest request) {
                return QueryPaginators.this.client.listQuickPicks(request);
            }
        });
    }

    public Iterable<QuickPickSummary> listQuickPicksRecordIterator(final ListQuickPicksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListQuickPicksRequest.Builder>(){

            @Override
            public ListQuickPicksRequest.Builder get() {
                return ListQuickPicksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, String>(){

            @Override
            public String apply(ListQuickPicksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuickPicksRequest.Builder>, ListQuickPicksRequest>(){

            @Override
            public ListQuickPicksRequest apply(RequestBuilderAndToken<ListQuickPicksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuickPicksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQuickPicksRequest, ListQuickPicksResponse>(){

            @Override
            public ListQuickPicksResponse apply(ListQuickPicksRequest request) {
                return QueryPaginators.this.client.listQuickPicks(request);
            }
        }, (Function)new Function<ListQuickPicksResponse, List<QuickPickSummary>>(){

            @Override
            public List<QuickPickSummary> apply(ListQuickPicksResponse response) {
                return response.getItems();
            }
        });
    }
}

