/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.ProbeMode;
import com.oracle.bmc.apmsynthetics.model.Protocol;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="numberOfHops")
    private final Integer numberOfHops;
    @JsonProperty(value="probePerHop")
    private final Integer probePerHop;
    @JsonProperty(value="transmissionRate")
    private final Integer transmissionRate;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="probeMode")
    private final ProbeMode probeMode;

    @Deprecated
    @ConstructorProperties(value={"numberOfHops", "probePerHop", "transmissionRate", "protocol", "probeMode"})
    public NetworkConfiguration(Integer numberOfHops, Integer probePerHop, Integer transmissionRate, Protocol protocol, ProbeMode probeMode) {
        this.numberOfHops = numberOfHops;
        this.probePerHop = probePerHop;
        this.transmissionRate = transmissionRate;
        this.protocol = protocol;
        this.probeMode = probeMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getNumberOfHops() {
        return this.numberOfHops;
    }

    public Integer getProbePerHop() {
        return this.probePerHop;
    }

    public Integer getTransmissionRate() {
        return this.transmissionRate;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public ProbeMode getProbeMode() {
        return this.probeMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("numberOfHops=").append(String.valueOf(this.numberOfHops));
        sb.append(", probePerHop=").append(String.valueOf(this.probePerHop));
        sb.append(", transmissionRate=").append(String.valueOf(this.transmissionRate));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", probeMode=").append(String.valueOf((Object)this.probeMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration)((Object)o);
        return Objects.equals(this.numberOfHops, other.numberOfHops) && Objects.equals(this.probePerHop, other.probePerHop) && Objects.equals(this.transmissionRate, other.transmissionRate) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.probeMode, (Object)other.probeMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.numberOfHops == null ? 43 : this.numberOfHops.hashCode());
        result = result * 59 + (this.probePerHop == null ? 43 : this.probePerHop.hashCode());
        result = result * 59 + (this.transmissionRate == null ? 43 : this.transmissionRate.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.probeMode == null ? 43 : this.probeMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="numberOfHops")
        private Integer numberOfHops;
        @JsonProperty(value="probePerHop")
        private Integer probePerHop;
        @JsonProperty(value="transmissionRate")
        private Integer transmissionRate;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="probeMode")
        private ProbeMode probeMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder numberOfHops(Integer numberOfHops) {
            this.numberOfHops = numberOfHops;
            this.__explicitlySet__.add("numberOfHops");
            return this;
        }

        public Builder probePerHop(Integer probePerHop) {
            this.probePerHop = probePerHop;
            this.__explicitlySet__.add("probePerHop");
            return this;
        }

        public Builder transmissionRate(Integer transmissionRate) {
            this.transmissionRate = transmissionRate;
            this.__explicitlySet__.add("transmissionRate");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder probeMode(ProbeMode probeMode) {
            this.probeMode = probeMode;
            this.__explicitlySet__.add("probeMode");
            return this;
        }

        public NetworkConfiguration build() {
            NetworkConfiguration model = new NetworkConfiguration(this.numberOfHops, this.probePerHop, this.transmissionRate, this.protocol, this.probeMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkConfiguration model) {
            if (model.wasPropertyExplicitlySet("numberOfHops")) {
                this.numberOfHops(model.getNumberOfHops());
            }
            if (model.wasPropertyExplicitlySet("probePerHop")) {
                this.probePerHop(model.getProbePerHop());
            }
            if (model.wasPropertyExplicitlySet("transmissionRate")) {
                this.transmissionRate(model.getTransmissionRate());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("probeMode")) {
                this.probeMode(model.getProbeMode());
            }
            return this;
        }
    }
}

