/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonitorResultData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="byteContent")
    private final byte[] byteContent;
    @JsonProperty(value="stringContent")
    private final String stringContent;
    @JsonProperty(value="timestamp")
    private final Date timestamp;

    @Deprecated
    @ConstructorProperties(value={"name", "byteContent", "stringContent", "timestamp"})
    public MonitorResultData(String name, byte[] byteContent, String stringContent, Date timestamp) {
        this.name = name;
        this.byteContent = byteContent;
        this.stringContent = stringContent;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public byte[] getByteContent() {
        return this.byteContent;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitorResultData(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", byteContent=").append(includeByteArrayContents ? Arrays.toString(this.byteContent) : String.valueOf(this.byteContent) + (this.byteContent != null ? " (byte[" + this.byteContent.length + "])" : ""));
        sb.append(", stringContent=").append(String.valueOf(this.stringContent));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitorResultData)) {
            return false;
        }
        MonitorResultData other = (MonitorResultData)((Object)o);
        return Objects.equals(this.name, other.name) && Arrays.equals(this.byteContent, other.byteContent) && Objects.equals(this.stringContent, other.stringContent) && Objects.equals(this.timestamp, other.timestamp) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + Arrays.hashCode(this.byteContent);
        result = result * 59 + (this.stringContent == null ? 43 : this.stringContent.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="byteContent")
        private byte[] byteContent;
        @JsonProperty(value="stringContent")
        private String stringContent;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder byteContent(byte[] byteContent) {
            this.byteContent = byteContent;
            this.__explicitlySet__.add("byteContent");
            return this;
        }

        public Builder stringContent(String stringContent) {
            this.stringContent = stringContent;
            this.__explicitlySet__.add("stringContent");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public MonitorResultData build() {
            MonitorResultData model = new MonitorResultData(this.name, this.byteContent, this.stringContent, this.timestamp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitorResultData model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("byteContent")) {
                this.byteContent(model.getByteContent());
            }
            if (model.wasPropertyExplicitlySet("stringContent")) {
                this.stringContent(model.getStringContent());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            return this;
        }
    }
}

