/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmcontrolplane.ApmDomainAsync;
import com.oracle.bmc.apmcontrolplane.model.ApmDomain;
import com.oracle.bmc.apmcontrolplane.model.ApmDomainSummary;
import com.oracle.bmc.apmcontrolplane.model.DataKeySummary;
import com.oracle.bmc.apmcontrolplane.model.WorkRequest;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestError;
import com.oracle.bmc.apmcontrolplane.model.WorkRequestLogEntry;
import com.oracle.bmc.apmcontrolplane.requests.ChangeApmDomainCompartmentRequest;
import com.oracle.bmc.apmcontrolplane.requests.CreateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.DeleteApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GenerateDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListApmDomainsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.apmcontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.apmcontrolplane.requests.RemoveDataKeysRequest;
import com.oracle.bmc.apmcontrolplane.requests.UpdateApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.responses.ChangeApmDomainCompartmentResponse;
import com.oracle.bmc.apmcontrolplane.responses.CreateApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.DeleteApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GenerateDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListApmDomainsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.apmcontrolplane.responses.ListWorkRequestsResponse;
import com.oracle.bmc.apmcontrolplane.responses.RemoveDataKeysResponse;
import com.oracle.bmc.apmcontrolplane.responses.UpdateApmDomainResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmDomainAsyncClient
extends BaseAsyncClient
implements ApmDomainAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMDOMAIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-cp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApmDomainAsyncClient.class);

    private ApmDomainAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeApmDomainCompartmentResponse> changeApmDomainCompartment(ChangeApmDomainCompartmentRequest request, AsyncHandler<ChangeApmDomainCompartmentRequest, ChangeApmDomainCompartmentResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApmDomainCompartmentDetails(), "changeApmDomainCompartmentDetails is required");
        return this.clientCall(request, ChangeApmDomainCompartmentResponse::builder).logger(LOG, "changeApmDomainCompartment").serviceDetails("ApmDomain", "ChangeApmDomainCompartment", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/ChangeApmDomainCompartment").method(Method.POST).requestBuilder(ChangeApmDomainCompartmentRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeApmDomainCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeApmDomainCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApmDomainResponse> createApmDomain(CreateApmDomainRequest request, AsyncHandler<CreateApmDomainRequest, CreateApmDomainResponse> handler) {
        Objects.requireNonNull(request.getCreateApmDomainDetails(), "createApmDomainDetails is required");
        return this.clientCall(request, CreateApmDomainResponse::builder).logger(LOG, "createApmDomain").serviceDetails("ApmDomain", "CreateApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/CreateApmDomain").method(Method.POST).requestBuilder(CreateApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateApmDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteApmDomainResponse> deleteApmDomain(DeleteApmDomainRequest request, AsyncHandler<DeleteApmDomainRequest, DeleteApmDomainResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApmDomainResponse::builder).logger(LOG, "deleteApmDomain").serviceDetails("ApmDomain", "DeleteApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/DeleteApmDomain").method(Method.DELETE).requestBuilder(DeleteApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteApmDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateDataKeysResponse> generateDataKeys(GenerateDataKeysRequest request, AsyncHandler<GenerateDataKeysRequest, GenerateDataKeysResponse> handler) {
        Objects.requireNonNull(request.getGenerateDataKeysListDetails(), "generateDataKeysListDetails is required");
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateDataKeysResponse::builder).logger(LOG, "generateDataKeys").serviceDetails("ApmDomain", "GenerateDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKey/GenerateDataKeys").method(Method.POST).requestBuilder(GenerateDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("generateDataKeys").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", GenerateDataKeysResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateDataKeysResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApmDomainResponse> getApmDomain(GetApmDomainRequest request, AsyncHandler<GetApmDomainRequest, GetApmDomainResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApmDomainResponse::builder).logger(LOG, "getApmDomain").serviceDetails("ApmDomain", "GetApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/GetApmDomain").method(Method.GET).requestBuilder(GetApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApmDomain.class, GetApmDomainResponse.Builder::apmDomain).handleResponseHeaderString("etag", GetApmDomainResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApmDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ApmDomain", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListApmDomainWorkRequestsResponse> listApmDomainWorkRequests(ListApmDomainWorkRequestsRequest request, AsyncHandler<ListApmDomainWorkRequestsRequest, ListApmDomainWorkRequestsResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListApmDomainWorkRequestsResponse::builder).logger(LOG, "listApmDomainWorkRequests").serviceDetails("ApmDomain", "ListApmDomainWorkRequests", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/ListApmDomainWorkRequests").method(Method.GET).requestBuilder(ListApmDomainWorkRequestsRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("workRequests").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListApmDomainWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListApmDomainWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApmDomainWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListApmDomainsResponse> listApmDomains(ListApmDomainsRequest request, AsyncHandler<ListApmDomainsRequest, ListApmDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApmDomainsResponse::builder).logger(LOG, "listApmDomains").serviceDetails("ApmDomain", "ListApmDomains", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomainSummary/ListApmDomains").method(Method.GET).requestBuilder(ListApmDomainsRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ApmDomainSummary.class, ListApmDomainsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListApmDomainsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApmDomainsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDataKeysResponse> listDataKeys(ListDataKeysRequest request, AsyncHandler<ListDataKeysRequest, ListDataKeysResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataKeysResponse::builder).logger(LOG, "listDataKeys").serviceDetails("ApmDomain", "ListDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKeySummary/ListDataKeys").method(Method.GET).requestBuilder(ListDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("dataKeys").appendEnumQueryParam("dataKeyType", (BmcEnum)request.getDataKeyType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DataKeySummary.class, ListDataKeysResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDataKeysResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ApmDomain", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ApmDomain", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ApmDomain", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200630").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RemoveDataKeysResponse> removeDataKeys(RemoveDataKeysRequest request, AsyncHandler<RemoveDataKeysRequest, RemoveDataKeysResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDataKeysListDetails(), "removeDataKeysListDetails is required");
        return this.clientCall(request, RemoveDataKeysResponse::builder).logger(LOG, "removeDataKeys").serviceDetails("ApmDomain", "RemoveDataKeys", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/DataKey/RemoveDataKeys").method(Method.POST).requestBuilder(RemoveDataKeysRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).appendPathParam("actions").appendPathParam("removeDataKeys").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveDataKeysResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveDataKeysResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateApmDomainResponse> updateApmDomain(UpdateApmDomainRequest request, AsyncHandler<UpdateApmDomainRequest, UpdateApmDomainResponse> handler) {
        Validate.notBlank((String)request.getApmDomainId(), (String)"apmDomainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApmDomainDetails(), "updateApmDomainDetails is required");
        return this.clientCall(request, UpdateApmDomainResponse::builder).logger(LOG, "updateApmDomain").serviceDetails("ApmDomain", "UpdateApmDomain", "https://docs.oracle.com/iaas/api/#/en/apm-control-plane/20200630/ApmDomain/UpdateApmDomain").method(Method.PUT).requestBuilder(UpdateApmDomainRequest::builder).basePath("/20200630").appendPathParam("apmDomains").appendPathParam(request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateApmDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateApmDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ApmDomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApmDomainAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApmDomainAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApmDomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApmDomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApmDomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApmDomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmDomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApmDomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmDomainAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApmDomainAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApmDomainAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

