/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmconfig.model.UpdateConfigDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateConfigRequest
extends BmcRequest<UpdateConfigDetails> {
    private String apmDomainId;
    private String configId;
    private UpdateConfigDetails updateConfigDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcDryRun;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public UpdateConfigDetails getUpdateConfigDetails() {
        return this.updateConfigDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcDryRun() {
        return this.opcDryRun;
    }

    @InternalSdk
    public UpdateConfigDetails getBody$() {
        return this.updateConfigDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).configId(this.configId).updateConfigDetails(this.updateConfigDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcDryRun(this.opcDryRun);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",configId=").append(String.valueOf(this.configId));
        sb.append(",updateConfigDetails=").append(String.valueOf((Object)this.updateConfigDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcDryRun=").append(String.valueOf(this.opcDryRun));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConfigRequest)) {
            return false;
        }
        UpdateConfigRequest other = (UpdateConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.configId, other.configId) && Objects.equals((Object)this.updateConfigDetails, (Object)other.updateConfigDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcDryRun, other.opcDryRun);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.configId == null ? 43 : this.configId.hashCode());
        result = result * 59 + (this.updateConfigDetails == null ? 43 : this.updateConfigDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcDryRun == null ? 43 : this.opcDryRun.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConfigRequest, UpdateConfigDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String configId = null;
        private UpdateConfigDetails updateConfigDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcDryRun = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public Builder updateConfigDetails(UpdateConfigDetails updateConfigDetails) {
            this.updateConfigDetails = updateConfigDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcDryRun(String opcDryRun) {
            this.opcDryRun = opcDryRun;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConfigRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.configId(o.getConfigId());
            this.updateConfigDetails(o.getUpdateConfigDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcDryRun(o.getOpcDryRun());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConfigRequest build() {
            UpdateConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConfigDetails body) {
            this.updateConfigDetails(body);
            return this;
        }

        public UpdateConfigRequest buildWithoutInvocationCallback() {
            UpdateConfigRequest request = new UpdateConfigRequest();
            request.apmDomainId = this.apmDomainId;
            request.configId = this.configId;
            request.updateConfigDetails = this.updateConfigDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcDryRun = this.opcDryRun;
            return request;
        }
    }
}

