/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmconfig.model.CreateConfigDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateConfigRequest
extends BmcRequest<CreateConfigDetails> {
    private String apmDomainId;
    private CreateConfigDetails createConfigDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String opcDryRun;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public CreateConfigDetails getCreateConfigDetails() {
        return this.createConfigDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcDryRun() {
        return this.opcDryRun;
    }

    @InternalSdk
    public CreateConfigDetails getBody$() {
        return this.createConfigDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).createConfigDetails(this.createConfigDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).opcDryRun(this.opcDryRun);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",createConfigDetails=").append(String.valueOf((Object)this.createConfigDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcDryRun=").append(String.valueOf(this.opcDryRun));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConfigRequest)) {
            return false;
        }
        CreateConfigRequest other = (CreateConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.createConfigDetails, (Object)other.createConfigDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcDryRun, other.opcDryRun);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.createConfigDetails == null ? 43 : this.createConfigDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcDryRun == null ? 43 : this.opcDryRun.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateConfigRequest, CreateConfigDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private CreateConfigDetails createConfigDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String opcDryRun = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder createConfigDetails(CreateConfigDetails createConfigDetails) {
            this.createConfigDetails = createConfigDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcDryRun(String opcDryRun) {
            this.opcDryRun = opcDryRun;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateConfigRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.createConfigDetails(o.getCreateConfigDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.opcDryRun(o.getOpcDryRun());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateConfigRequest build() {
            CreateConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateConfigDetails body) {
            this.createConfigDetails(body);
            return this;
        }

        public CreateConfigRequest buildWithoutInvocationCallback() {
            CreateConfigRequest request = new CreateConfigRequest();
            request.apmDomainId = this.apmDomainId;
            request.createConfigDetails = this.createConfigDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.opcDryRun = this.opcDryRun;
            return request;
        }
    }
}

