/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmconfig.ConfigAsync;
import com.oracle.bmc.apmconfig.model.Config;
import com.oracle.bmc.apmconfig.model.ConfigCollection;
import com.oracle.bmc.apmconfig.model.NamespaceCollection;
import com.oracle.bmc.apmconfig.model.NamespaceMetricCollection;
import com.oracle.bmc.apmconfig.requests.CreateConfigRequest;
import com.oracle.bmc.apmconfig.requests.DeleteConfigRequest;
import com.oracle.bmc.apmconfig.requests.GetConfigRequest;
import com.oracle.bmc.apmconfig.requests.ListConfigsRequest;
import com.oracle.bmc.apmconfig.requests.RetrieveNamespaceMetricsRequest;
import com.oracle.bmc.apmconfig.requests.RetrieveNamespacesRequest;
import com.oracle.bmc.apmconfig.requests.UpdateConfigRequest;
import com.oracle.bmc.apmconfig.requests.ValidateSpanFilterPatternRequest;
import com.oracle.bmc.apmconfig.responses.CreateConfigResponse;
import com.oracle.bmc.apmconfig.responses.DeleteConfigResponse;
import com.oracle.bmc.apmconfig.responses.GetConfigResponse;
import com.oracle.bmc.apmconfig.responses.ListConfigsResponse;
import com.oracle.bmc.apmconfig.responses.RetrieveNamespaceMetricsResponse;
import com.oracle.bmc.apmconfig.responses.RetrieveNamespacesResponse;
import com.oracle.bmc.apmconfig.responses.UpdateConfigResponse;
import com.oracle.bmc.apmconfig.responses.ValidateSpanFilterPatternResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigAsyncClient
extends BaseAsyncClient
implements ConfigAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONFIG").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-config.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigAsyncClient.class);

    private ConfigAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateConfigResponse> createConfig(CreateConfigRequest request, AsyncHandler<CreateConfigRequest, CreateConfigResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getCreateConfigDetails(), "createConfigDetails is required");
        return this.clientCall(request, CreateConfigResponse::builder).logger(LOG, "createConfig").serviceDetails("Config", "CreateConfig", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/Config/CreateConfig").method(Method.POST).requestBuilder(CreateConfigRequest::builder).basePath("/20210201").appendPathParam("configs").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).hasBody().handleBody(Config.class, CreateConfigResponse.Builder::config).handleResponseHeaderString("etag", CreateConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConfigResponse> deleteConfig(DeleteConfigRequest request, AsyncHandler<DeleteConfigRequest, DeleteConfigResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getConfigId(), (String)"configId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConfigResponse::builder).logger(LOG, "deleteConfig").serviceDetails("Config", "DeleteConfig", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/Config/DeleteConfig").method(Method.DELETE).requestBuilder(DeleteConfigRequest::builder).basePath("/20210201").appendPathParam("configs").appendPathParam(request.getConfigId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConfigResponse> getConfig(GetConfigRequest request, AsyncHandler<GetConfigRequest, GetConfigResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getConfigId(), (String)"configId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConfigResponse::builder).logger(LOG, "getConfig").serviceDetails("Config", "GetConfig", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/Config/GetConfig").method(Method.GET).requestBuilder(GetConfigRequest::builder).basePath("/20210201").appendPathParam("configs").appendPathParam(request.getConfigId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Config.class, GetConfigResponse.Builder::config).handleResponseHeaderString("etag", GetConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListConfigsResponse> listConfigs(ListConfigsRequest request, AsyncHandler<ListConfigsRequest, ListConfigsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, ListConfigsResponse::builder).logger(LOG, "listConfigs").serviceDetails("Config", "ListConfigs", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/ConfigCollection/ListConfigs").method(Method.GET).requestBuilder(ListConfigsRequest::builder).basePath("/20210201").appendPathParam("configs").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("configType", (Object)request.getConfigType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("optionsGroup", (Object)request.getOptionsGroup()).appendListQueryParam("definedTagEquals", request.getDefinedTagEquals(), CollectionFormatType.Multi).appendListQueryParam("freeformTagEquals", request.getFreeformTagEquals(), CollectionFormatType.Multi).appendListQueryParam("definedTagExists", request.getDefinedTagExists(), CollectionFormatType.Multi).appendListQueryParam("freeformTagExists", request.getFreeformTagExists(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigCollection.class, ListConfigsResponse.Builder::configCollection).handleResponseHeaderString("opc-request-id", ListConfigsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConfigsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RetrieveNamespaceMetricsResponse> retrieveNamespaceMetrics(RetrieveNamespaceMetricsRequest request, AsyncHandler<RetrieveNamespaceMetricsRequest, RetrieveNamespaceMetricsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getRetrieveNamespaceMetricsDetails(), "retrieveNamespaceMetricsDetails is required");
        return this.clientCall(request, RetrieveNamespaceMetricsResponse::builder).logger(LOG, "retrieveNamespaceMetrics").serviceDetails("Config", "RetrieveNamespaceMetrics", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/MetricGroup/RetrieveNamespaceMetrics").method(Method.POST).requestBuilder(RetrieveNamespaceMetricsRequest::builder).basePath("/20210201").appendPathParam("actions").appendPathParam("retrieveNamespaceMetrics").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NamespaceMetricCollection.class, RetrieveNamespaceMetricsResponse.Builder::namespaceMetricCollection).handleResponseHeaderString("opc-request-id", RetrieveNamespaceMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RetrieveNamespaceMetricsResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RetrieveNamespacesResponse> retrieveNamespaces(RetrieveNamespacesRequest request, AsyncHandler<RetrieveNamespacesRequest, RetrieveNamespacesResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, RetrieveNamespacesResponse::builder).logger(LOG, "retrieveNamespaces").serviceDetails("Config", "RetrieveNamespaces", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/MetricGroup/RetrieveNamespaces").method(Method.POST).requestBuilder(RetrieveNamespacesRequest::builder).basePath("/20210201").appendPathParam("actions").appendPathParam("retrieveNamespaces").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamespaceCollection.class, RetrieveNamespacesResponse.Builder::namespaceCollection).handleResponseHeaderString("opc-request-id", RetrieveNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RetrieveNamespacesResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateConfigResponse> updateConfig(UpdateConfigRequest request, AsyncHandler<UpdateConfigRequest, UpdateConfigResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getConfigId(), (String)"configId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConfigDetails(), "updateConfigDetails is required");
        return this.clientCall(request, UpdateConfigResponse::builder).logger(LOG, "updateConfig").serviceDetails("Config", "UpdateConfig", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/Config/UpdateConfig").method(Method.PUT).requestBuilder(UpdateConfigRequest::builder).basePath("/20210201").appendPathParam("configs").appendPathParam(request.getConfigId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).hasBody().handleBody(Config.class, UpdateConfigResponse.Builder::config).handleResponseHeaderString("etag", UpdateConfigResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ValidateSpanFilterPatternResponse> validateSpanFilterPattern(ValidateSpanFilterPatternRequest request, AsyncHandler<ValidateSpanFilterPatternRequest, ValidateSpanFilterPatternResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getValidateSpanFilterPatternDetails(), "validateSpanFilterPatternDetails is required");
        return this.clientCall(request, ValidateSpanFilterPatternResponse::builder).logger(LOG, "validateSpanFilterPattern").serviceDetails("Config", "ValidateSpanFilterPattern", "https://docs.oracle.com/iaas/api/#/en/apm-config/20210201/SpanFilter/ValidateSpanFilterPattern").method(Method.POST).requestBuilder(ValidateSpanFilterPatternRequest::builder).basePath("/20210201").appendPathParam("actions").appendPathParam("validateSpanFilterPattern").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ValidateSpanFilterPatternResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ConfigAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ConfigAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ConfigAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ConfigAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ConfigAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ConfigAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ConfigAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ConfigAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ConfigAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ConfigAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ConfigAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ConfigAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

