/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apigateway.model.UpdateSdkDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSdkRequest
extends BmcRequest<UpdateSdkDetails> {
    private String sdkId;
    private UpdateSdkDetails updateSdkDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSdkId() {
        return this.sdkId;
    }

    public UpdateSdkDetails getUpdateSdkDetails() {
        return this.updateSdkDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSdkDetails getBody$() {
        return this.updateSdkDetails;
    }

    public Builder toBuilder() {
        return new Builder().sdkId(this.sdkId).updateSdkDetails(this.updateSdkDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sdkId=").append(String.valueOf(this.sdkId));
        sb.append(",updateSdkDetails=").append(String.valueOf((Object)this.updateSdkDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSdkRequest)) {
            return false;
        }
        UpdateSdkRequest other = (UpdateSdkRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sdkId, other.sdkId) && Objects.equals((Object)this.updateSdkDetails, (Object)other.updateSdkDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sdkId == null ? 43 : this.sdkId.hashCode());
        result = result * 59 + (this.updateSdkDetails == null ? 43 : this.updateSdkDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSdkRequest, UpdateSdkDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sdkId = null;
        private UpdateSdkDetails updateSdkDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder sdkId(String sdkId) {
            this.sdkId = sdkId;
            return this;
        }

        public Builder updateSdkDetails(UpdateSdkDetails updateSdkDetails) {
            this.updateSdkDetails = updateSdkDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSdkRequest o) {
            this.sdkId(o.getSdkId());
            this.updateSdkDetails(o.getUpdateSdkDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSdkRequest build() {
            UpdateSdkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSdkDetails body) {
            this.updateSdkDetails(body);
            return this;
        }

        public UpdateSdkRequest buildWithoutInvocationCallback() {
            UpdateSdkRequest request = new UpdateSdkRequest();
            request.sdkId = this.sdkId;
            request.updateSdkDetails = this.updateSdkDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

