/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetApiContentRequest
extends BmcRequest<Void> {
    private String apiId;
    private String opcRequestId;
    private String ifMatch;
    private Range range;

    public String getApiId() {
        return this.apiId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Range getRange() {
        return this.range;
    }

    public Builder toBuilder() {
        return new Builder().apiId(this.apiId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).range(this.range);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apiId=").append(String.valueOf(this.apiId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",range=").append(String.valueOf(this.range));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetApiContentRequest)) {
            return false;
        }
        GetApiContentRequest other = (GetApiContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apiId, other.apiId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.range, other.range);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apiId == null ? 43 : this.apiId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.range == null ? 43 : this.range.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetApiContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apiId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private Range range = null;

        public Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetApiContentRequest o) {
            this.apiId(o.getApiId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.range(o.getRange());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetApiContentRequest build() {
            GetApiContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetApiContentRequest buildWithoutInvocationCallback() {
            GetApiContentRequest request = new GetApiContentRequest();
            request.apiId = this.apiId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.range = this.range;
            return request;
        }
    }
}

