/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apigateway.model.CreateSdkDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateSdkRequest
extends BmcRequest<CreateSdkDetails> {
    private CreateSdkDetails createSdkDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateSdkDetails getCreateSdkDetails() {
        return this.createSdkDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateSdkDetails getBody$() {
        return this.createSdkDetails;
    }

    public Builder toBuilder() {
        return new Builder().createSdkDetails(this.createSdkDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createSdkDetails=").append(String.valueOf((Object)this.createSdkDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSdkRequest)) {
            return false;
        }
        CreateSdkRequest other = (CreateSdkRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createSdkDetails, (Object)other.createSdkDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createSdkDetails == null ? 43 : this.createSdkDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateSdkRequest, CreateSdkDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateSdkDetails createSdkDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createSdkDetails(CreateSdkDetails createSdkDetails) {
            this.createSdkDetails = createSdkDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSdkRequest o) {
            this.createSdkDetails(o.getCreateSdkDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSdkRequest build() {
            CreateSdkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateSdkDetails body) {
            this.createSdkDetails(body);
            return this;
        }

        public CreateSdkRequest buildWithoutInvocationCallback() {
            CreateSdkRequest request = new CreateSdkRequest();
            request.createSdkDetails = this.createSdkDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

