/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ApiSpecificationRouteBackend;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class HTTPBackend
extends ApiSpecificationRouteBackend {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="connectTimeoutInSeconds")
    private final Float connectTimeoutInSeconds;
    @JsonProperty(value="readTimeoutInSeconds")
    private final Float readTimeoutInSeconds;
    @JsonProperty(value="sendTimeoutInSeconds")
    private final Float sendTimeoutInSeconds;
    @JsonProperty(value="isSslVerifyDisabled")
    private final Boolean isSslVerifyDisabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HTTPBackend(String url, Float connectTimeoutInSeconds, Float readTimeoutInSeconds, Float sendTimeoutInSeconds, Boolean isSslVerifyDisabled) {
        this.url = url;
        this.connectTimeoutInSeconds = connectTimeoutInSeconds;
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        this.sendTimeoutInSeconds = sendTimeoutInSeconds;
        this.isSslVerifyDisabled = isSslVerifyDisabled;
    }

    public String getUrl() {
        return this.url;
    }

    public Float getConnectTimeoutInSeconds() {
        return this.connectTimeoutInSeconds;
    }

    public Float getReadTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    public Float getSendTimeoutInSeconds() {
        return this.sendTimeoutInSeconds;
    }

    public Boolean getIsSslVerifyDisabled() {
        return this.isSslVerifyDisabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTPBackend(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", connectTimeoutInSeconds=").append(String.valueOf(this.connectTimeoutInSeconds));
        sb.append(", readTimeoutInSeconds=").append(String.valueOf(this.readTimeoutInSeconds));
        sb.append(", sendTimeoutInSeconds=").append(String.valueOf(this.sendTimeoutInSeconds));
        sb.append(", isSslVerifyDisabled=").append(String.valueOf(this.isSslVerifyDisabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTTPBackend)) {
            return false;
        }
        HTTPBackend other = (HTTPBackend)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals(this.connectTimeoutInSeconds, other.connectTimeoutInSeconds) && Objects.equals(this.readTimeoutInSeconds, other.readTimeoutInSeconds) && Objects.equals(this.sendTimeoutInSeconds, other.sendTimeoutInSeconds) && Objects.equals(this.isSslVerifyDisabled, other.isSslVerifyDisabled) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.connectTimeoutInSeconds == null ? 43 : this.connectTimeoutInSeconds.hashCode());
        result = result * 59 + (this.readTimeoutInSeconds == null ? 43 : this.readTimeoutInSeconds.hashCode());
        result = result * 59 + (this.sendTimeoutInSeconds == null ? 43 : this.sendTimeoutInSeconds.hashCode());
        result = result * 59 + (this.isSslVerifyDisabled == null ? 43 : this.isSslVerifyDisabled.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="connectTimeoutInSeconds")
        private Float connectTimeoutInSeconds;
        @JsonProperty(value="readTimeoutInSeconds")
        private Float readTimeoutInSeconds;
        @JsonProperty(value="sendTimeoutInSeconds")
        private Float sendTimeoutInSeconds;
        @JsonProperty(value="isSslVerifyDisabled")
        private Boolean isSslVerifyDisabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder connectTimeoutInSeconds(Float connectTimeoutInSeconds) {
            this.connectTimeoutInSeconds = connectTimeoutInSeconds;
            this.__explicitlySet__.add("connectTimeoutInSeconds");
            return this;
        }

        public Builder readTimeoutInSeconds(Float readTimeoutInSeconds) {
            this.readTimeoutInSeconds = readTimeoutInSeconds;
            this.__explicitlySet__.add("readTimeoutInSeconds");
            return this;
        }

        public Builder sendTimeoutInSeconds(Float sendTimeoutInSeconds) {
            this.sendTimeoutInSeconds = sendTimeoutInSeconds;
            this.__explicitlySet__.add("sendTimeoutInSeconds");
            return this;
        }

        public Builder isSslVerifyDisabled(Boolean isSslVerifyDisabled) {
            this.isSslVerifyDisabled = isSslVerifyDisabled;
            this.__explicitlySet__.add("isSslVerifyDisabled");
            return this;
        }

        public HTTPBackend build() {
            HTTPBackend model = new HTTPBackend(this.url, this.connectTimeoutInSeconds, this.readTimeoutInSeconds, this.sendTimeoutInSeconds, this.isSslVerifyDisabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HTTPBackend model) {
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("connectTimeoutInSeconds")) {
                this.connectTimeoutInSeconds(model.getConnectTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("readTimeoutInSeconds")) {
                this.readTimeoutInSeconds(model.getReadTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("sendTimeoutInSeconds")) {
                this.sendTimeoutInSeconds(model.getSendTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("isSslVerifyDisabled")) {
                this.isSslVerifyDisabled(model.getIsSslVerifyDisabled());
            }
            return this;
        }
    }
}

