/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ResponseCacheDetails;
import com.oracle.bmc.apigateway.model.ResponseCacheRespServer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalRespCache
extends ResponseCacheDetails {
    @JsonProperty(value="servers")
    private final List<ResponseCacheRespServer> servers;
    @JsonProperty(value="authenticationSecretId")
    private final String authenticationSecretId;
    @JsonProperty(value="authenticationSecretVersionNumber")
    private final Long authenticationSecretVersionNumber;
    @JsonProperty(value="isSslEnabled")
    private final Boolean isSslEnabled;
    @JsonProperty(value="isSslVerifyDisabled")
    private final Boolean isSslVerifyDisabled;
    @JsonProperty(value="connectTimeoutInMs")
    private final Integer connectTimeoutInMs;
    @JsonProperty(value="readTimeoutInMs")
    private final Integer readTimeoutInMs;
    @JsonProperty(value="sendTimeoutInMs")
    private final Integer sendTimeoutInMs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalRespCache(List<ResponseCacheRespServer> servers, String authenticationSecretId, Long authenticationSecretVersionNumber, Boolean isSslEnabled, Boolean isSslVerifyDisabled, Integer connectTimeoutInMs, Integer readTimeoutInMs, Integer sendTimeoutInMs) {
        this.servers = servers;
        this.authenticationSecretId = authenticationSecretId;
        this.authenticationSecretVersionNumber = authenticationSecretVersionNumber;
        this.isSslEnabled = isSslEnabled;
        this.isSslVerifyDisabled = isSslVerifyDisabled;
        this.connectTimeoutInMs = connectTimeoutInMs;
        this.readTimeoutInMs = readTimeoutInMs;
        this.sendTimeoutInMs = sendTimeoutInMs;
    }

    public List<ResponseCacheRespServer> getServers() {
        return this.servers;
    }

    public String getAuthenticationSecretId() {
        return this.authenticationSecretId;
    }

    public Long getAuthenticationSecretVersionNumber() {
        return this.authenticationSecretVersionNumber;
    }

    public Boolean getIsSslEnabled() {
        return this.isSslEnabled;
    }

    public Boolean getIsSslVerifyDisabled() {
        return this.isSslVerifyDisabled;
    }

    public Integer getConnectTimeoutInMs() {
        return this.connectTimeoutInMs;
    }

    public Integer getReadTimeoutInMs() {
        return this.readTimeoutInMs;
    }

    public Integer getSendTimeoutInMs() {
        return this.sendTimeoutInMs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalRespCache(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", servers=").append(String.valueOf(this.servers));
        sb.append(", authenticationSecretId=").append(String.valueOf(this.authenticationSecretId));
        sb.append(", authenticationSecretVersionNumber=").append(String.valueOf(this.authenticationSecretVersionNumber));
        sb.append(", isSslEnabled=").append(String.valueOf(this.isSslEnabled));
        sb.append(", isSslVerifyDisabled=").append(String.valueOf(this.isSslVerifyDisabled));
        sb.append(", connectTimeoutInMs=").append(String.valueOf(this.connectTimeoutInMs));
        sb.append(", readTimeoutInMs=").append(String.valueOf(this.readTimeoutInMs));
        sb.append(", sendTimeoutInMs=").append(String.valueOf(this.sendTimeoutInMs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalRespCache)) {
            return false;
        }
        ExternalRespCache other = (ExternalRespCache)((Object)o);
        return Objects.equals(this.servers, other.servers) && Objects.equals(this.authenticationSecretId, other.authenticationSecretId) && Objects.equals(this.authenticationSecretVersionNumber, other.authenticationSecretVersionNumber) && Objects.equals(this.isSslEnabled, other.isSslEnabled) && Objects.equals(this.isSslVerifyDisabled, other.isSslVerifyDisabled) && Objects.equals(this.connectTimeoutInMs, other.connectTimeoutInMs) && Objects.equals(this.readTimeoutInMs, other.readTimeoutInMs) && Objects.equals(this.sendTimeoutInMs, other.sendTimeoutInMs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.servers == null ? 43 : this.servers.hashCode());
        result = result * 59 + (this.authenticationSecretId == null ? 43 : this.authenticationSecretId.hashCode());
        result = result * 59 + (this.authenticationSecretVersionNumber == null ? 43 : this.authenticationSecretVersionNumber.hashCode());
        result = result * 59 + (this.isSslEnabled == null ? 43 : this.isSslEnabled.hashCode());
        result = result * 59 + (this.isSslVerifyDisabled == null ? 43 : this.isSslVerifyDisabled.hashCode());
        result = result * 59 + (this.connectTimeoutInMs == null ? 43 : this.connectTimeoutInMs.hashCode());
        result = result * 59 + (this.readTimeoutInMs == null ? 43 : this.readTimeoutInMs.hashCode());
        result = result * 59 + (this.sendTimeoutInMs == null ? 43 : this.sendTimeoutInMs.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="servers")
        private List<ResponseCacheRespServer> servers;
        @JsonProperty(value="authenticationSecretId")
        private String authenticationSecretId;
        @JsonProperty(value="authenticationSecretVersionNumber")
        private Long authenticationSecretVersionNumber;
        @JsonProperty(value="isSslEnabled")
        private Boolean isSslEnabled;
        @JsonProperty(value="isSslVerifyDisabled")
        private Boolean isSslVerifyDisabled;
        @JsonProperty(value="connectTimeoutInMs")
        private Integer connectTimeoutInMs;
        @JsonProperty(value="readTimeoutInMs")
        private Integer readTimeoutInMs;
        @JsonProperty(value="sendTimeoutInMs")
        private Integer sendTimeoutInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder servers(List<ResponseCacheRespServer> servers) {
            this.servers = servers;
            this.__explicitlySet__.add("servers");
            return this;
        }

        public Builder authenticationSecretId(String authenticationSecretId) {
            this.authenticationSecretId = authenticationSecretId;
            this.__explicitlySet__.add("authenticationSecretId");
            return this;
        }

        public Builder authenticationSecretVersionNumber(Long authenticationSecretVersionNumber) {
            this.authenticationSecretVersionNumber = authenticationSecretVersionNumber;
            this.__explicitlySet__.add("authenticationSecretVersionNumber");
            return this;
        }

        public Builder isSslEnabled(Boolean isSslEnabled) {
            this.isSslEnabled = isSslEnabled;
            this.__explicitlySet__.add("isSslEnabled");
            return this;
        }

        public Builder isSslVerifyDisabled(Boolean isSslVerifyDisabled) {
            this.isSslVerifyDisabled = isSslVerifyDisabled;
            this.__explicitlySet__.add("isSslVerifyDisabled");
            return this;
        }

        public Builder connectTimeoutInMs(Integer connectTimeoutInMs) {
            this.connectTimeoutInMs = connectTimeoutInMs;
            this.__explicitlySet__.add("connectTimeoutInMs");
            return this;
        }

        public Builder readTimeoutInMs(Integer readTimeoutInMs) {
            this.readTimeoutInMs = readTimeoutInMs;
            this.__explicitlySet__.add("readTimeoutInMs");
            return this;
        }

        public Builder sendTimeoutInMs(Integer sendTimeoutInMs) {
            this.sendTimeoutInMs = sendTimeoutInMs;
            this.__explicitlySet__.add("sendTimeoutInMs");
            return this;
        }

        public ExternalRespCache build() {
            ExternalRespCache model = new ExternalRespCache(this.servers, this.authenticationSecretId, this.authenticationSecretVersionNumber, this.isSslEnabled, this.isSslVerifyDisabled, this.connectTimeoutInMs, this.readTimeoutInMs, this.sendTimeoutInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalRespCache model) {
            if (model.wasPropertyExplicitlySet("servers")) {
                this.servers(model.getServers());
            }
            if (model.wasPropertyExplicitlySet("authenticationSecretId")) {
                this.authenticationSecretId(model.getAuthenticationSecretId());
            }
            if (model.wasPropertyExplicitlySet("authenticationSecretVersionNumber")) {
                this.authenticationSecretVersionNumber(model.getAuthenticationSecretVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("isSslEnabled")) {
                this.isSslEnabled(model.getIsSslEnabled());
            }
            if (model.wasPropertyExplicitlySet("isSslVerifyDisabled")) {
                this.isSslVerifyDisabled(model.getIsSslVerifyDisabled());
            }
            if (model.wasPropertyExplicitlySet("connectTimeoutInMs")) {
                this.connectTimeoutInMs(model.getConnectTimeoutInMs());
            }
            if (model.wasPropertyExplicitlySet("readTimeoutInMs")) {
                this.readTimeoutInMs(model.getReadTimeoutInMs());
            }
            if (model.wasPropertyExplicitlySet("sendTimeoutInMs")) {
                this.sendTimeoutInMs(model.getSendTimeoutInMs());
            }
            return this;
        }
    }
}

