/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AuthenticationServerPolicy;
import com.oracle.bmc.apigateway.model.SelectionSourcePolicy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DynamicAuthenticationPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="selectionSource")
    private final SelectionSourcePolicy selectionSource;
    @JsonProperty(value="authenticationServers")
    private final List<AuthenticationServerPolicy> authenticationServers;

    @Deprecated
    @ConstructorProperties(value={"selectionSource", "authenticationServers"})
    public DynamicAuthenticationPolicy(SelectionSourcePolicy selectionSource, List<AuthenticationServerPolicy> authenticationServers) {
        this.selectionSource = selectionSource;
        this.authenticationServers = authenticationServers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public SelectionSourcePolicy getSelectionSource() {
        return this.selectionSource;
    }

    public List<AuthenticationServerPolicy> getAuthenticationServers() {
        return this.authenticationServers;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DynamicAuthenticationPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("selectionSource=").append(String.valueOf((Object)this.selectionSource));
        sb.append(", authenticationServers=").append(String.valueOf(this.authenticationServers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicAuthenticationPolicy)) {
            return false;
        }
        DynamicAuthenticationPolicy other = (DynamicAuthenticationPolicy)((Object)o);
        return Objects.equals((Object)this.selectionSource, (Object)other.selectionSource) && Objects.equals(this.authenticationServers, other.authenticationServers) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.selectionSource == null ? 43 : this.selectionSource.hashCode());
        result = result * 59 + (this.authenticationServers == null ? 43 : this.authenticationServers.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="selectionSource")
        private SelectionSourcePolicy selectionSource;
        @JsonProperty(value="authenticationServers")
        private List<AuthenticationServerPolicy> authenticationServers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder selectionSource(SelectionSourcePolicy selectionSource) {
            this.selectionSource = selectionSource;
            this.__explicitlySet__.add("selectionSource");
            return this;
        }

        public Builder authenticationServers(List<AuthenticationServerPolicy> authenticationServers) {
            this.authenticationServers = authenticationServers;
            this.__explicitlySet__.add("authenticationServers");
            return this;
        }

        public DynamicAuthenticationPolicy build() {
            DynamicAuthenticationPolicy model = new DynamicAuthenticationPolicy(this.selectionSource, this.authenticationServers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DynamicAuthenticationPolicy model) {
            if (model.wasPropertyExplicitlySet("selectionSource")) {
                this.selectionSource(model.getSelectionSource());
            }
            if (model.wasPropertyExplicitlySet("authenticationServers")) {
                this.authenticationServers(model.getAuthenticationServers());
            }
            return this;
        }
    }
}

