/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiValidationDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="msg")
    private final String msg;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="src")
    private final List<List<BigDecimal>> src;

    @Deprecated
    @ConstructorProperties(value={"msg", "severity", "src"})
    public ApiValidationDetail(String msg, Severity severity, List<List<BigDecimal>> src) {
        this.msg = msg;
        this.severity = severity;
        this.src = src;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMsg() {
        return this.msg;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<List<BigDecimal>> getSrc() {
        return this.src;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiValidationDetail(");
        sb.append("super=").append(super.toString());
        sb.append("msg=").append(String.valueOf(this.msg));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", src=").append(String.valueOf(this.src));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiValidationDetail)) {
            return false;
        }
        ApiValidationDetail other = (ApiValidationDetail)((Object)o);
        return Objects.equals(this.msg, other.msg) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.src, other.src) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.msg == null ? 43 : this.msg.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.src == null ? 43 : this.src.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        Info("INFO"),
        Warning("WARNING"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="msg")
        private String msg;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="src")
        private List<List<BigDecimal>> src;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder msg(String msg) {
            this.msg = msg;
            this.__explicitlySet__.add("msg");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder src(List<List<BigDecimal>> src) {
            this.src = src;
            this.__explicitlySet__.add("src");
            return this;
        }

        public ApiValidationDetail build() {
            ApiValidationDetail model = new ApiValidationDetail(this.msg, this.severity, this.src);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiValidationDetail model) {
            if (model.wasPropertyExplicitlySet("msg")) {
                this.msg(model.getMsg());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("src")) {
                this.src(model.getSrc());
            }
            return this;
        }
    }
}

