/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ApiSpecificationLoggingPolicies;
import com.oracle.bmc.apigateway.model.ApiSpecificationRouteBackend;
import com.oracle.bmc.apigateway.model.ApiSpecificationRouteRequestPolicies;
import com.oracle.bmc.apigateway.model.ApiSpecificationRouteResponsePolicies;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiSpecificationRoute
extends ExplicitlySetBmcModel {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="methods")
    private final List<Methods> methods;
    @JsonProperty(value="requestPolicies")
    private final ApiSpecificationRouteRequestPolicies requestPolicies;
    @JsonProperty(value="responsePolicies")
    private final ApiSpecificationRouteResponsePolicies responsePolicies;
    @JsonProperty(value="loggingPolicies")
    private final ApiSpecificationLoggingPolicies loggingPolicies;
    @JsonProperty(value="backend")
    private final ApiSpecificationRouteBackend backend;

    @Deprecated
    @ConstructorProperties(value={"path", "methods", "requestPolicies", "responsePolicies", "loggingPolicies", "backend"})
    public ApiSpecificationRoute(String path, List<Methods> methods, ApiSpecificationRouteRequestPolicies requestPolicies, ApiSpecificationRouteResponsePolicies responsePolicies, ApiSpecificationLoggingPolicies loggingPolicies, ApiSpecificationRouteBackend backend) {
        this.path = path;
        this.methods = methods;
        this.requestPolicies = requestPolicies;
        this.responsePolicies = responsePolicies;
        this.loggingPolicies = loggingPolicies;
        this.backend = backend;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPath() {
        return this.path;
    }

    public List<Methods> getMethods() {
        return this.methods;
    }

    public ApiSpecificationRouteRequestPolicies getRequestPolicies() {
        return this.requestPolicies;
    }

    public ApiSpecificationRouteResponsePolicies getResponsePolicies() {
        return this.responsePolicies;
    }

    public ApiSpecificationLoggingPolicies getLoggingPolicies() {
        return this.loggingPolicies;
    }

    public ApiSpecificationRouteBackend getBackend() {
        return this.backend;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiSpecificationRoute(");
        sb.append("super=").append(super.toString());
        sb.append("path=").append(String.valueOf(this.path));
        sb.append(", methods=").append(String.valueOf(this.methods));
        sb.append(", requestPolicies=").append(String.valueOf((Object)this.requestPolicies));
        sb.append(", responsePolicies=").append(String.valueOf((Object)this.responsePolicies));
        sb.append(", loggingPolicies=").append(String.valueOf((Object)this.loggingPolicies));
        sb.append(", backend=").append(String.valueOf((Object)this.backend));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiSpecificationRoute)) {
            return false;
        }
        ApiSpecificationRoute other = (ApiSpecificationRoute)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals(this.methods, other.methods) && Objects.equals((Object)this.requestPolicies, (Object)other.requestPolicies) && Objects.equals((Object)this.responsePolicies, (Object)other.responsePolicies) && Objects.equals((Object)this.loggingPolicies, (Object)other.loggingPolicies) && Objects.equals((Object)this.backend, (Object)other.backend) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.methods == null ? 43 : this.methods.hashCode());
        result = result * 59 + (this.requestPolicies == null ? 43 : this.requestPolicies.hashCode());
        result = result * 59 + (this.responsePolicies == null ? 43 : this.responsePolicies.hashCode());
        result = result * 59 + (this.loggingPolicies == null ? 43 : this.loggingPolicies.hashCode());
        result = result * 59 + (this.backend == null ? 43 : this.backend.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Methods implements BmcEnum
    {
        Any("ANY"),
        Head("HEAD"),
        Get("GET"),
        Post("POST"),
        Put("PUT"),
        Patch("PATCH"),
        Delete("DELETE"),
        Options("OPTIONS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Methods> map;

        private Methods(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Methods create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Methods', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Methods.class);
            map = new HashMap<String, Methods>();
            for (Methods v : Methods.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="methods")
        private List<Methods> methods;
        @JsonProperty(value="requestPolicies")
        private ApiSpecificationRouteRequestPolicies requestPolicies;
        @JsonProperty(value="responsePolicies")
        private ApiSpecificationRouteResponsePolicies responsePolicies;
        @JsonProperty(value="loggingPolicies")
        private ApiSpecificationLoggingPolicies loggingPolicies;
        @JsonProperty(value="backend")
        private ApiSpecificationRouteBackend backend;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder methods(List<Methods> methods) {
            this.methods = methods;
            this.__explicitlySet__.add("methods");
            return this;
        }

        public Builder requestPolicies(ApiSpecificationRouteRequestPolicies requestPolicies) {
            this.requestPolicies = requestPolicies;
            this.__explicitlySet__.add("requestPolicies");
            return this;
        }

        public Builder responsePolicies(ApiSpecificationRouteResponsePolicies responsePolicies) {
            this.responsePolicies = responsePolicies;
            this.__explicitlySet__.add("responsePolicies");
            return this;
        }

        public Builder loggingPolicies(ApiSpecificationLoggingPolicies loggingPolicies) {
            this.loggingPolicies = loggingPolicies;
            this.__explicitlySet__.add("loggingPolicies");
            return this;
        }

        public Builder backend(ApiSpecificationRouteBackend backend) {
            this.backend = backend;
            this.__explicitlySet__.add("backend");
            return this;
        }

        public ApiSpecificationRoute build() {
            ApiSpecificationRoute model = new ApiSpecificationRoute(this.path, this.methods, this.requestPolicies, this.responsePolicies, this.loggingPolicies, this.backend);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiSpecificationRoute model) {
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("methods")) {
                this.methods(model.getMethods());
            }
            if (model.wasPropertyExplicitlySet("requestPolicies")) {
                this.requestPolicies(model.getRequestPolicies());
            }
            if (model.wasPropertyExplicitlySet("responsePolicies")) {
                this.responsePolicies(model.getResponsePolicies());
            }
            if (model.wasPropertyExplicitlySet("loggingPolicies")) {
                this.loggingPolicies(model.getLoggingPolicies());
            }
            if (model.wasPropertyExplicitlySet("backend")) {
                this.backend(model.getBackend());
            }
            return this;
        }
    }
}

