/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.UsagePlans;
import com.oracle.bmc.apigateway.model.UsagePlan;
import com.oracle.bmc.apigateway.requests.GetUsagePlanRequest;
import com.oracle.bmc.apigateway.responses.GetUsagePlanResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class UsagePlansWaiters {
    private final ExecutorService executorService;
    private final UsagePlans client;

    public UsagePlansWaiters(ExecutorService executorService, UsagePlans client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetUsagePlanRequest, GetUsagePlanResponse> forUsagePlan(GetUsagePlanRequest request, UsagePlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forUsagePlan(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetUsagePlanRequest, GetUsagePlanResponse> forUsagePlan(GetUsagePlanRequest request, UsagePlan.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forUsagePlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetUsagePlanRequest, GetUsagePlanResponse> forUsagePlan(GetUsagePlanRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, UsagePlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forUsagePlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetUsagePlanRequest, GetUsagePlanResponse> forUsagePlan(BmcGenericWaiter waiter, GetUsagePlanRequest request, UsagePlan.LifecycleState ... targetStates) {
        final HashSet<UsagePlan.LifecycleState> targetStatesSet = new HashSet<UsagePlan.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetUsagePlanRequest, GetUsagePlanResponse>(){

            @Override
            public GetUsagePlanResponse apply(GetUsagePlanRequest request) {
                return UsagePlansWaiters.this.client.getUsagePlan(request);
            }
        }, (Predicate)new Predicate<GetUsagePlanResponse>(){

            @Override
            public boolean test(GetUsagePlanResponse response) {
                return targetStatesSet.contains((Object)response.getUsagePlan().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)UsagePlan.LifecycleState.Deleted)), (Object)request);
    }
}

