/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Subscribers;
import com.oracle.bmc.apigateway.model.SubscriberSummary;
import com.oracle.bmc.apigateway.requests.ListSubscribersRequest;
import com.oracle.bmc.apigateway.responses.ListSubscribersResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SubscribersPaginators {
    private final Subscribers client;

    public SubscribersPaginators(Subscribers client) {
        this.client = client;
    }

    public Iterable<ListSubscribersResponse> listSubscribersResponseIterator(final ListSubscribersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscribersRequest.Builder>(){

            @Override
            public ListSubscribersRequest.Builder get() {
                return ListSubscribersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscribersResponse, String>(){

            @Override
            public String apply(ListSubscribersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscribersRequest.Builder>, ListSubscribersRequest>(){

            @Override
            public ListSubscribersRequest apply(RequestBuilderAndToken<ListSubscribersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscribersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscribersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscribersRequest, ListSubscribersResponse>(){

            @Override
            public ListSubscribersResponse apply(ListSubscribersRequest request) {
                return SubscribersPaginators.this.client.listSubscribers(request);
            }
        });
    }

    public Iterable<SubscriberSummary> listSubscribersRecordIterator(final ListSubscribersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscribersRequest.Builder>(){

            @Override
            public ListSubscribersRequest.Builder get() {
                return ListSubscribersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscribersResponse, String>(){

            @Override
            public String apply(ListSubscribersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscribersRequest.Builder>, ListSubscribersRequest>(){

            @Override
            public ListSubscribersRequest apply(RequestBuilderAndToken<ListSubscribersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscribersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscribersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscribersRequest, ListSubscribersResponse>(){

            @Override
            public ListSubscribersResponse apply(ListSubscribersRequest request) {
                return SubscribersPaginators.this.client.listSubscribers(request);
            }
        }, (Function)new Function<ListSubscribersResponse, List<SubscriberSummary>>(){

            @Override
            public List<SubscriberSummary> apply(ListSubscribersResponse response) {
                return response.getSubscriberCollection().getItems();
            }
        });
    }
}

