/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.ApiGateway;
import com.oracle.bmc.apigateway.model.Api;
import com.oracle.bmc.apigateway.model.Certificate;
import com.oracle.bmc.apigateway.model.Sdk;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetSdkRequest;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetSdkResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ApiGatewayWaiters {
    private final ExecutorService executorService;
    private final ApiGateway client;

    public ApiGatewayWaiters(ExecutorService executorService, ApiGateway client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetApiRequest, GetApiResponse> forApi(GetApiRequest request, Api.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApi(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApiRequest, GetApiResponse> forApi(GetApiRequest request, Api.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApi(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApiRequest, GetApiResponse> forApi(GetApiRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Api.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApi(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApiRequest, GetApiResponse> forApi(BmcGenericWaiter waiter, GetApiRequest request, Api.LifecycleState ... targetStates) {
        final HashSet<Api.LifecycleState> targetStatesSet = new HashSet<Api.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApiRequest, GetApiResponse>(){

            @Override
            public GetApiResponse apply(GetApiRequest request) {
                return ApiGatewayWaiters.this.client.getApi(request);
            }
        }, (Predicate)new Predicate<GetApiResponse>(){

            @Override
            public boolean test(GetApiResponse response) {
                return targetStatesSet.contains((Object)response.getApi().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Api.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, Certificate.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, Certificate.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Certificate.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(BmcGenericWaiter waiter, GetCertificateRequest request, Certificate.LifecycleState ... targetStates) {
        final HashSet<Certificate.LifecycleState> targetStatesSet = new HashSet<Certificate.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCertificateRequest, GetCertificateResponse>(){

            @Override
            public GetCertificateResponse apply(GetCertificateRequest request) {
                return ApiGatewayWaiters.this.client.getCertificate(request);
            }
        }, (Predicate)new Predicate<GetCertificateResponse>(){

            @Override
            public boolean test(GetCertificateResponse response) {
                return targetStatesSet.contains((Object)response.getCertificate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Certificate.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSdkRequest, GetSdkResponse> forSdk(GetSdkRequest request, Sdk.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSdk(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSdkRequest, GetSdkResponse> forSdk(GetSdkRequest request, Sdk.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSdk(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSdkRequest, GetSdkResponse> forSdk(GetSdkRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Sdk.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSdk(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSdkRequest, GetSdkResponse> forSdk(BmcGenericWaiter waiter, GetSdkRequest request, Sdk.LifecycleState ... targetStates) {
        final HashSet<Sdk.LifecycleState> targetStatesSet = new HashSet<Sdk.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSdkRequest, GetSdkResponse>(){

            @Override
            public GetSdkResponse apply(GetSdkRequest request) {
                return ApiGatewayWaiters.this.client.getSdk(request);
            }
        }, (Predicate)new Predicate<GetSdkResponse>(){

            @Override
            public boolean test(GetSdkResponse response) {
                return targetStatesSet.contains((Object)response.getSdk().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Sdk.LifecycleState.Deleted)), (Object)request);
    }
}

