/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.ApiGatewayAsync;
import com.oracle.bmc.apigateway.model.Api;
import com.oracle.bmc.apigateway.model.ApiCollection;
import com.oracle.bmc.apigateway.model.ApiSpecification;
import com.oracle.bmc.apigateway.model.ApiValidations;
import com.oracle.bmc.apigateway.model.Certificate;
import com.oracle.bmc.apigateway.model.CertificateCollection;
import com.oracle.bmc.apigateway.model.Sdk;
import com.oracle.bmc.apigateway.model.SdkCollection;
import com.oracle.bmc.apigateway.model.SdkLanguageTypeCollection;
import com.oracle.bmc.apigateway.requests.ChangeApiCompartmentRequest;
import com.oracle.bmc.apigateway.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateApiRequest;
import com.oracle.bmc.apigateway.requests.CreateCertificateRequest;
import com.oracle.bmc.apigateway.requests.CreateSdkRequest;
import com.oracle.bmc.apigateway.requests.DeleteApiRequest;
import com.oracle.bmc.apigateway.requests.DeleteCertificateRequest;
import com.oracle.bmc.apigateway.requests.DeleteSdkRequest;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.requests.GetApiDeploymentSpecificationRequest;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetApiValidationsRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetSdkRequest;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.ListSdkLanguageTypesRequest;
import com.oracle.bmc.apigateway.requests.ListSdksRequest;
import com.oracle.bmc.apigateway.requests.UpdateApiRequest;
import com.oracle.bmc.apigateway.requests.UpdateCertificateRequest;
import com.oracle.bmc.apigateway.requests.UpdateSdkRequest;
import com.oracle.bmc.apigateway.responses.ChangeApiCompartmentResponse;
import com.oracle.bmc.apigateway.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateApiResponse;
import com.oracle.bmc.apigateway.responses.CreateCertificateResponse;
import com.oracle.bmc.apigateway.responses.CreateSdkResponse;
import com.oracle.bmc.apigateway.responses.DeleteApiResponse;
import com.oracle.bmc.apigateway.responses.DeleteCertificateResponse;
import com.oracle.bmc.apigateway.responses.DeleteSdkResponse;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.apigateway.responses.GetApiDeploymentSpecificationResponse;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetApiValidationsResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetSdkResponse;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.ListSdkLanguageTypesResponse;
import com.oracle.bmc.apigateway.responses.ListSdksResponse;
import com.oracle.bmc.apigateway.responses.UpdateApiResponse;
import com.oracle.bmc.apigateway.responses.UpdateCertificateResponse;
import com.oracle.bmc.apigateway.responses.UpdateSdkResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayAsyncClient
extends BaseAsyncClient
implements ApiGatewayAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APIGATEWAY").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApiGatewayAsyncClient.class);

    private ApiGatewayAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeApiCompartmentResponse> changeApiCompartment(ChangeApiCompartmentRequest request, AsyncHandler<ChangeApiCompartmentRequest, ChangeApiCompartmentResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeApiCompartmentDetails(), "changeApiCompartmentDetails is required");
        return this.clientCall(request, ChangeApiCompartmentResponse::builder).logger(LOG, "changeApiCompartment").serviceDetails("ApiGateway", "ChangeApiCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/ChangeApiCompartment").method(Method.POST).requestBuilder(ChangeApiCompartmentRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeApiCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeApiCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request, AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCertificateCompartmentDetails(), "changeCertificateCompartmentDetails is required");
        return this.clientCall(request, ChangeCertificateCompartmentResponse::builder).logger(LOG, "changeCertificateCompartment").serviceDetails("ApiGateway", "ChangeCertificateCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Certificate/ChangeCertificateCompartment").method(Method.POST).requestBuilder(ChangeCertificateCompartmentRequest::builder).basePath("/20190501").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCertificateCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateApiResponse> createApi(CreateApiRequest request, AsyncHandler<CreateApiRequest, CreateApiResponse> handler) {
        Objects.requireNonNull(request.getCreateApiDetails(), "createApiDetails is required");
        return this.clientCall(request, CreateApiResponse::builder).logger(LOG, "createApi").serviceDetails("ApiGateway", "CreateApi", "").method(Method.POST).requestBuilder(CreateApiRequest::builder).basePath("/20190501").appendPathParam("apis").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Api.class, CreateApiResponse.Builder::api).handleResponseHeaderString("etag", CreateApiResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateApiResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateApiResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateApiResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        return this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("ApiGateway", "CreateCertificate", "").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20190501").appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Certificate.class, CreateCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", CreateCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateCertificateResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateSdkResponse> createSdk(CreateSdkRequest request, AsyncHandler<CreateSdkRequest, CreateSdkResponse> handler) {
        Objects.requireNonNull(request.getCreateSdkDetails(), "createSdkDetails is required");
        return this.clientCall(request, CreateSdkResponse::builder).logger(LOG, "createSdk").serviceDetails("ApiGateway", "CreateSdk", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Sdk/CreateSdk").method(Method.POST).requestBuilder(CreateSdkRequest::builder).basePath("/20190501").appendPathParam("sdks").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Sdk.class, CreateSdkResponse.Builder::sdk).handleResponseHeaderString("etag", CreateSdkResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateSdkResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSdkResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSdkResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteApiResponse> deleteApi(DeleteApiRequest request, AsyncHandler<DeleteApiRequest, DeleteApiResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteApiResponse::builder).logger(LOG, "deleteApi").serviceDetails("ApiGateway", "DeleteApi", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/DeleteApi").method(Method.DELETE).requestBuilder(DeleteApiRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteApiResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteApiResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCertificateResponse::builder).logger(LOG, "deleteCertificate").serviceDetails("ApiGateway", "DeleteCertificate", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Certificate/DeleteCertificate").method(Method.DELETE).requestBuilder(DeleteCertificateRequest::builder).basePath("/20190501").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSdkResponse> deleteSdk(DeleteSdkRequest request, AsyncHandler<DeleteSdkRequest, DeleteSdkResponse> handler) {
        Validate.notBlank((String)request.getSdkId(), (String)"sdkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSdkResponse::builder).logger(LOG, "deleteSdk").serviceDetails("ApiGateway", "DeleteSdk", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Sdk/DeleteSdk").method(Method.DELETE).requestBuilder(DeleteSdkRequest::builder).basePath("/20190501").appendPathParam("sdks").appendPathParam(request.getSdkId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteSdkResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSdkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApiResponse> getApi(GetApiRequest request, AsyncHandler<GetApiRequest, GetApiResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApiResponse::builder).logger(LOG, "getApi").serviceDetails("ApiGateway", "GetApi", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/GetApi").method(Method.GET).requestBuilder(GetApiRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Api.class, GetApiResponse.Builder::api).handleResponseHeaderString("etag", GetApiResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApiResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApiContentResponse> getApiContent(GetApiContentRequest request, AsyncHandler<GetApiContentRequest, GetApiContentResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApiContentResponse::builder).logger(LOG, "getApiContent").serviceDetails("ApiGateway", "GetApiContent", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/GetApiContent").method(Method.GET).requestBuilder(GetApiContentRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).appendPathParam("content").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("range", request.getRange()).handleBody(InputStream.class, GetApiContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetApiContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApiContentResponse.Builder::opcRequestId).handleResponseHeaderString("x-content-sha256", GetApiContentResponse.Builder::xContentSha256).callAsync(handler);
    }

    @Override
    public Future<GetApiDeploymentSpecificationResponse> getApiDeploymentSpecification(GetApiDeploymentSpecificationRequest request, AsyncHandler<GetApiDeploymentSpecificationRequest, GetApiDeploymentSpecificationResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApiDeploymentSpecificationResponse::builder).logger(LOG, "getApiDeploymentSpecification").serviceDetails("ApiGateway", "GetApiDeploymentSpecification", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/ApiSpecification/GetApiDeploymentSpecification").method(Method.GET).requestBuilder(GetApiDeploymentSpecificationRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).appendPathParam("deploymentSpecification").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(ApiSpecification.class, GetApiDeploymentSpecificationResponse.Builder::apiSpecification).handleResponseHeaderString("etag", GetApiDeploymentSpecificationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApiDeploymentSpecificationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetApiValidationsResponse> getApiValidations(GetApiValidationsRequest request, AsyncHandler<GetApiValidationsRequest, GetApiValidationsResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetApiValidationsResponse::builder).logger(LOG, "getApiValidations").serviceDetails("ApiGateway", "GetApiValidations", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/ApiValidations/GetApiValidations").method(Method.GET).requestBuilder(GetApiValidationsRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).appendPathParam("validations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleBody(ApiValidations.class, GetApiValidationsResponse.Builder::apiValidations).handleResponseHeaderString("etag", GetApiValidationsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetApiValidationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateResponse::builder).logger(LOG, "getCertificate").serviceDetails("ApiGateway", "GetCertificate", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Certificate/GetCertificate").method(Method.GET).requestBuilder(GetCertificateRequest::builder).basePath("/20190501").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Certificate.class, GetCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", GetCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSdkResponse> getSdk(GetSdkRequest request, AsyncHandler<GetSdkRequest, GetSdkResponse> handler) {
        Validate.notBlank((String)request.getSdkId(), (String)"sdkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSdkResponse::builder).logger(LOG, "getSdk").serviceDetails("ApiGateway", "GetSdk", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Sdk/GetSdk").method(Method.GET).requestBuilder(GetSdkRequest::builder).basePath("/20190501").appendPathParam("sdks").appendPathParam(request.getSdkId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Sdk.class, GetSdkResponse.Builder::sdk).handleResponseHeaderString("etag", GetSdkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSdkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListApisResponse> listApis(ListApisRequest request, AsyncHandler<ListApisRequest, ListApisResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApisResponse::builder).logger(LOG, "listApis").serviceDetails("ApiGateway", "ListApis", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/ListApis").method(Method.GET).requestBuilder(ListApisRequest::builder).basePath("/20190501").appendPathParam("apis").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApiCollection.class, ListApisResponse.Builder::apiCollection).handleResponseHeaderString("opc-request-id", ListApisResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApisResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListApisResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("ApiGateway", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Certificate/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20190501").appendPathParam("certificates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateCollection.class, ListCertificatesResponse.Builder::certificateCollection).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificatesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListCertificatesResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListSdkLanguageTypesResponse> listSdkLanguageTypes(ListSdkLanguageTypesRequest request, AsyncHandler<ListSdkLanguageTypesRequest, ListSdkLanguageTypesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSdkLanguageTypesResponse::builder).logger(LOG, "listSdkLanguageTypes").serviceDetails("ApiGateway", "ListSdkLanguageTypes", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/SdkLanguageTypeSummary/ListSdkLanguageTypes").method(Method.GET).requestBuilder(ListSdkLanguageTypesRequest::builder).basePath("/20190501").appendPathParam("sdkLanguageTypes").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SdkLanguageTypeCollection.class, ListSdkLanguageTypesResponse.Builder::sdkLanguageTypeCollection).handleResponseHeaderString("opc-request-id", ListSdkLanguageTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSdkLanguageTypesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSdkLanguageTypesResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListSdksResponse> listSdks(ListSdksRequest request, AsyncHandler<ListSdksRequest, ListSdksResponse> handler) {
        return this.clientCall(request, ListSdksResponse::builder).logger(LOG, "listSdks").serviceDetails("ApiGateway", "ListSdks", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Sdk/ListSdks").method(Method.GET).requestBuilder(ListSdksRequest::builder).basePath("/20190501").appendPathParam("sdks").appendQueryParam("sdkId", (Object)request.getSdkId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("apiId", (Object)request.getApiId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SdkCollection.class, ListSdksResponse.Builder::sdkCollection).handleResponseHeaderString("opc-request-id", ListSdksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSdksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSdksResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateApiResponse> updateApi(UpdateApiRequest request, AsyncHandler<UpdateApiRequest, UpdateApiResponse> handler) {
        Validate.notBlank((String)request.getApiId(), (String)"apiId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateApiDetails(), "updateApiDetails is required");
        return this.clientCall(request, UpdateApiResponse::builder).logger(LOG, "updateApi").serviceDetails("ApiGateway", "UpdateApi", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Api/UpdateApi").method(Method.PUT).requestBuilder(UpdateApiRequest::builder).basePath("/20190501").appendPathParam("apis").appendPathParam(request.getApiId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateApiResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateApiResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request, AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCertificateDetails(), "updateCertificateDetails is required");
        return this.clientCall(request, UpdateCertificateResponse::builder).logger(LOG, "updateCertificate").serviceDetails("ApiGateway", "UpdateCertificate", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Certificate/UpdateCertificate").method(Method.PUT).requestBuilder(UpdateCertificateRequest::builder).basePath("/20190501").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateCertificateResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSdkResponse> updateSdk(UpdateSdkRequest request, AsyncHandler<UpdateSdkRequest, UpdateSdkResponse> handler) {
        Validate.notBlank((String)request.getSdkId(), (String)"sdkId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSdkDetails(), "updateSdkDetails is required");
        return this.clientCall(request, UpdateSdkResponse::builder).logger(LOG, "updateSdk").serviceDetails("ApiGateway", "UpdateSdk", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Sdk/UpdateSdk").method(Method.PUT).requestBuilder(UpdateSdkRequest::builder).basePath("/20190501").appendPathParam("sdks").appendPathParam(request.getSdkId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateSdkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApiGatewayAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApiGatewayAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApiGatewayAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApiGatewayAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApiGatewayAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApiGatewayAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ApiGatewayAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApiGatewayAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApiGatewayAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApiGatewayAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApiGatewayAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

