/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.analytics.model.AccessControlServiceType;
import com.oracle.bmc.analytics.model.NetworkEndpointDetails;
import com.oracle.bmc.analytics.model.VirtualCloudNetwork;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="networkEndpointType")
@JsonFilter(value="explicitlySetFilter")
public final class PublicEndpointDetails
extends NetworkEndpointDetails {
    @JsonProperty(value="whitelistedIps")
    private final List<String> whitelistedIps;
    @JsonProperty(value="whitelistedVcns")
    private final List<VirtualCloudNetwork> whitelistedVcns;
    @JsonProperty(value="whitelistedServices")
    private final List<AccessControlServiceType> whitelistedServices;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PublicEndpointDetails(List<String> whitelistedIps, List<VirtualCloudNetwork> whitelistedVcns, List<AccessControlServiceType> whitelistedServices) {
        this.whitelistedIps = whitelistedIps;
        this.whitelistedVcns = whitelistedVcns;
        this.whitelistedServices = whitelistedServices;
    }

    public List<String> getWhitelistedIps() {
        return this.whitelistedIps;
    }

    public List<VirtualCloudNetwork> getWhitelistedVcns() {
        return this.whitelistedVcns;
    }

    public List<AccessControlServiceType> getWhitelistedServices() {
        return this.whitelistedServices;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PublicEndpointDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", whitelistedIps=").append(String.valueOf(this.whitelistedIps));
        sb.append(", whitelistedVcns=").append(String.valueOf(this.whitelistedVcns));
        sb.append(", whitelistedServices=").append(String.valueOf(this.whitelistedServices));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicEndpointDetails)) {
            return false;
        }
        PublicEndpointDetails other = (PublicEndpointDetails)((Object)o);
        return Objects.equals(this.whitelistedIps, other.whitelistedIps) && Objects.equals(this.whitelistedVcns, other.whitelistedVcns) && Objects.equals(this.whitelistedServices, other.whitelistedServices) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.whitelistedIps == null ? 43 : this.whitelistedIps.hashCode());
        result = result * 59 + (this.whitelistedVcns == null ? 43 : this.whitelistedVcns.hashCode());
        result = result * 59 + (this.whitelistedServices == null ? 43 : this.whitelistedServices.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="whitelistedIps")
        private List<String> whitelistedIps;
        @JsonProperty(value="whitelistedVcns")
        private List<VirtualCloudNetwork> whitelistedVcns;
        @JsonProperty(value="whitelistedServices")
        private List<AccessControlServiceType> whitelistedServices;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder whitelistedIps(List<String> whitelistedIps) {
            this.whitelistedIps = whitelistedIps;
            this.__explicitlySet__.add("whitelistedIps");
            return this;
        }

        public Builder whitelistedVcns(List<VirtualCloudNetwork> whitelistedVcns) {
            this.whitelistedVcns = whitelistedVcns;
            this.__explicitlySet__.add("whitelistedVcns");
            return this;
        }

        public Builder whitelistedServices(List<AccessControlServiceType> whitelistedServices) {
            this.whitelistedServices = whitelistedServices;
            this.__explicitlySet__.add("whitelistedServices");
            return this;
        }

        public PublicEndpointDetails build() {
            PublicEndpointDetails model = new PublicEndpointDetails(this.whitelistedIps, this.whitelistedVcns, this.whitelistedServices);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PublicEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("whitelistedIps")) {
                this.whitelistedIps(model.getWhitelistedIps());
            }
            if (model.wasPropertyExplicitlySet("whitelistedVcns")) {
                this.whitelistedVcns(model.getWhitelistedVcns());
            }
            if (model.wasPropertyExplicitlySet("whitelistedServices")) {
                this.whitelistedServices(model.getWhitelistedServices());
            }
            return this;
        }
    }
}

